// Variables para setear
onload=function() 
{
	cAyuda=document.getElementById("mensajesAyuda");
	cNombre=document.getElementById("ayudaTitulo");
	cTex=document.getElementById("ayudaTexto");
	divTransparente=document.getElementById("transparencia");
	divMensaje=document.getElementById("transparenciaMensaje");
	form=document.getElementById("formulario");
	urlDestino="mail.php";
	
	claseNormal="input";
	claseError="inputError";
	
	ayuda=new Array();
	ayuda["Empresa"]="Ingresa Empresa. De 4 a 100 caracteres. OBLIGATORIO";
	ayuda["Direccion"]="Ingresa el domicilio de la  Empresa. De 4 a 100 caracteres.";
	ayuda["Localidad"]="Ingresa Localidad. De 4 a 50 caracteres. Obligatorio";
	ayuda["Provincia"]="Seleccione Provincia. OBLIGATORIO";
	ayuda["Cpostal"]="Ingresa tus Cod.Postal. De 4 a 10 caracteres. OBLIGATORIO";
	ayuda["Cuit"]="Ingresa CUIT de la Empresa. xx-xxxxxxxx-x. OBLIGATORIO";
	ayuda["Telefono"]="Ingresa Telefono. De 4 a 50 caracteres.";
	ayuda["Email"]="Ingresa email. nombre@host.com. OBLIGATORIO";
	ayuda["Contacto"]="Ingrese Contacto de Empresa. De 4 a 100 caracteres. OBLIGATORIO";
	
	preCarga("../ok.gif", "../loading.gif", "../error.gif");
}

function preCarga()
{
	imagenes=new Array();
	for(i=0; i<arguments.length; i++)
	{
		imagenes[i]=document.createElement("img");
		imagenes[i].src=arguments[i];
	}
}

function nuevoAjax()
{ 
	var xmlhttp=false; 
	try 
	{ 
		// No IE
		xmlhttp=new ActiveXObject("Msxml2.XMLHTTP"); 
	}
	catch(e)
	{ 
		try
		{ 
			// IE 
			xmlhttp=new ActiveXObject("Microsoft.XMLHTTP"); 
		} 
		catch(E) { xmlhttp=false; }
	}
	if (!xmlhttp && typeof XMLHttpRequest!="undefined") { xmlhttp=new XMLHttpRequest(); } 
	return xmlhttp; 
}

function limpiaForm()
{
	for(i=0; i<=8; i++)
	{
		form.elements[i].className=claseNormal;
	}
	document.getElementById("inputContacto").className=claseNormal;
}

function campoError(campo)
{
	campo.className=claseError;
	error=1;
}

function ocultaMensaje()
{
	divTransparente.style.display="none";
}

function muestraMensaje(mensaje)
{
	divMensaje.innerHTML=mensaje;
	divTransparente.style.display="block";
}

function eliminaEspacios(cadena)
{
	// Funcion para eliminar espacios delante y detras de cada cadena
	while(cadena.charAt(cadena.length-1)==" ") cadena=cadena.substr(0, cadena.length-1);
	while(cadena.charAt(0)==" ") cadena=cadena.substr(1, cadena.length-1);
	return cadena;
}

function validaLongitud(valor, permiteVacio, minimo, maximo)
{
	var cantCar=valor.length;
	if(valor=="")
	{
		if(permiteVacio) return true;
		else return false;
	}
	else
	{
		if(cantCar>=minimo && cantCar<=maximo) return true;
		else return false;
	}
}

function validaCorreo(valor)
{
	var reg=/(^[a-zA-Z0-9._-]{1,30})@([a-zA-Z0-9.-]{1,30}$)/;
	if(reg.test(valor)) return true;
	else return false;
}

function validaForm()
{
	limpiaForm();
	error=0;
	
	var empresa=eliminaEspacios(form.inputEmpresa.value);
	var direccion=eliminaEspacios(form.inputDireccion.value);
	var localidad=eliminaEspacios(form.inputLocalidad.value);
	var provincia=eliminaEspacios(form.inputProvincia.value);
	var cpostal=eliminaEspacios(form.inputCpostal.value);
	var cuit=eliminaEspacios(form.inputCuit.value);
	var telefono=eliminaEspacios(form.inputTelefono.value);
	var email=eliminaEspacios(form.inputEmail.value);
	var contacto=eliminaEspacios(form.inputContacto.value);

	if(!validaLongitud(empresa, 0, 4, 100)) campoError(form.inputEmpresa);
	if(!validaLongitud(direccion, 0, 4, 100)) campoError(form.inputDireccion);
	if(!validaLongitud(localidad, 0, 4, 50)) campoError(form.inputLocalidad);
	if(!validaLongitud(provincia, 0, 4, 50)) campoError(form.inputProvincia);
	if(!validaLongitud(cpostal, 0, 4, 10)) campoError(form.inputCpostal);
	if(!validaLongitud(cuit, 0, 4, 13)) campoError(form.inputCuit);
	if(!validaLongitud(telefono, 1, 4, 50)) campoError(form.inputTelefono);
	if(!validaCorreo(email)) campoError(form.inputEmail);
	if(!validaLongitud(contacto, 0, 4, 100)) campoError(form.inputContacto);
	
	if(error==1)
	{
		var texto="<img src='error.gif' alt='Error'><br><br>Error: revise los campos en rojo.<br><br><button style='width:45px; height:18px; font-size:10px;' onClick='ocultaMensaje()' type='button'>Ok</button>";
		muestraMensaje(texto);
	}
	else
	{
		var texto="<img src='loading.gif' alt='Enviando'><br>Enviando. Por favor espere.<br><br><button style='width:60px; height:18px; font-size:10px;' onClick='ocultaMensaje()' type='button'>Ocultar</button>";
		muestraMensaje(texto);
		
		var ajax=nuevoAjax();
		ajax.open("POST", urlDestino, true);
		ajax.setRequestHeader("Content-Type", "application/x-www-form-urlencoded");
		ajax.send("empresa="+empresa+"&direccion="+direccion+"&localidad="+localidad+"&provincia="+provincia+"&cpostal="+cpostal+"&cuit="+cuit+"&telefono="+telefono+"&email="+email+"&contacto="+contacto);
		
		ajax.onreadystatechange=function()
		{
			if (ajax.readyState==8)
			{
				var respuesta=ajax.responseText;
				if(respuesta=="OK")
				{
					var texto="<img src='ok.gif' alt='Ok'><br>Gracias por su mensaje.<br>Le responderemos a la brevedad.<br><br><button style='width:45px; height:18px; font-size:10px;' onClick='ocultaMensaje()' type='button'>Ok</button>";
				}
				else var texto="<img src='error.gif'><br><br>Error: intente ms tarde.<br><br><button style='width:45px; height:18px; font-size:10px;' onClick='ocultaMensaje()' type='button'>Ok</button>";
				
				muestraMensaje(texto);
			}
		}
	}
}

// Mensajes de ayuda

if(navigator.userAgent.indexOf("MSIE")>=0) navegador=0;
else navegador=1;

function colocaAyuda(event)
{
	if(navegador==0)
	{
		var corX=window.event.clientX+document.documentElement.scrollLeft;
		var corY=window.event.clientY+document.documentElement.scrollTop;
	}
	else
	{
		var corX=event.clientX+window.scrollX;
		var corY=event.clientY+window.scrollY;
	}
	cAyuda.style.top=corY+20+"px";
	cAyuda.style.left=corX+15+"px";
}

function ocultaAyuda()
{
	cAyuda.style.display="none";
	if(navegador==0) 
	{
		document.detachEvent("onmousemove", colocaAyuda);
		document.detachEvent("onmouseout", ocultaAyuda);
	}
	else 
	{
		document.removeEventListener("mousemove", colocaAyuda, true);
		document.removeEventListener("mouseout", ocultaAyuda, true);
	}
}

function muestraAyuda(event, campo)
{
	colocaAyuda(event);
	
	if(navegador==0) 
	{ 
		document.attachEvent("onmousemove", colocaAyuda); 
		document.attachEvent("onmouseout", ocultaAyuda); 
	}
	else 
	{
		document.addEventListener("mousemove", colocaAyuda, true);
		document.addEventListener("mouseout", ocultaAyuda, true);
	}
	
	cNombre.innerHTML=campo;
	cTex.innerHTML=ayuda[campo];
	cAyuda.style.display="block";
}