<?php
if (isset($_GET["code"])) {
	
	require('clases/fpdf/fpdf.php');

	require ("clases/nota_pedido.class.php");

class PDF extends FPDF
{
	//Columna actual
	var $col=0;
	//Ordenada de comienzo de la columna
	var $y0;
	
	
	function Header()
	{
		$objNota = new NotaPedido();
		//Cabacera
		global $title;
		global $dia;
		global $IDREP;
		global $IDREPSUB;
		global $idvendedor;
		global $Cliente;
		global $MADERA;
		//$row_ven = VendedoresxID($idvendedor);
		$row = $objNota->representacion_id ($IDREP);
		$folder = "../clientes/img/";
		if ($IDREPSUB)
		{
			$logo_representacion = $objNota->subrepresentacion_image($IDREPSUB);
		} else {
			$logo_representacion = $objNota->representacion_image($IDREP);
		}
		$logo_emp= "logo.jpg";
		$this->SetFont('Arial','B',12);
		$w=0;
		$this->SetX(10);
		$this->SetDrawColor(0,0,0);
		$this->SetFillColor(255,255,255);
		$this->SetTextColor(0,0,0);
		$this->SetLineWidth(0.3);
		$this->Cell($w,18,$title,1,1,'C',1);
		if (!empty($row["img_logo"])){
			$this->Image($folder.$logo_representacion,11,13,0,9,'',$row["web"]);
		}
		$this->Image($folder.$logo_emp,160,13,0,13,'','http://www.sovicsrl.com.ar');
		$this->SetFont('Arial','B',9);
		$this->Cell(100,6,utf8_decode($row["domicilio"]).' - '.$row["localidad"],1,0,'L');
		$this->Cell(90,6,'CUIT: 30-71090838-5',1,0,'C');
		$this->Ln();
		$this->Cell(100,6,$row["provincia"].' ('.$row["cpostal"].') - CUIT: '.$row["cuit"],1,0,'L');
		$this->Cell(90,6,'E-mail: rlavilla@arnet.com.ar',1,0,'C');
		$this->Ln();
		$this->Cell($w,6,'Fecha: '.$dia,1,1,'R',1);
		$this->Ln();
	
		
		//Guardar ordenada
		$this->y0=$this->GetY();
	}
	
	function Footer()
	{
		//Pie de pgina
		$this->SetY(-15);
		$this->SetFont('Arial','I',8);
		$this->SetTextColor(128);
		$this->Cell(0,10,'Pgina '.$this->PageNo(),0,0,'C');
	}
	
	function Cabecera($text)
	{
		$this->SetFont('Arial','B',12);
		$this->SetDrawColor(0,0,0);
		$this->SetFillColor(192,192,192);
		$this->SetTextColor(0,0,0);
		$this->SetLineWidth(0.5);
		$this->Cell($w,5,$text,1,1,'C',1);
	}
	
	function CabeceraSLinea($text)
	{
		$this->SetFont('Arial','B',12);
		$this->SetDrawColor(0,0,0);
		$this->SetFillColor(192,192,192);
		$this->SetTextColor(0,0,0);
		$this->SetLineWidth(0.5);
		$this->Cell($w,5,$text,0,1,'C',1);
	}
	
	function CabeceraDescuento($text)
	{
		$this->SetFont('Arial','B',12);
		$this->SetDrawColor(51,102,255);
		$this->SetFillColor(51,102,255);
		$this->SetTextColor(255,255,255);
		$this->SetLineWidth(0.5);
		$this->Cell($w,5,$text,1,1,'C',1);
	}
	
		
	function ChapterClient($cliente,$cuit,$domicilio,$localidad,$provincia,$cpostal,$email1,$email2,$telefono,$celular,$vendedor)
	{
		//Abrir fichero de texto
		$this->Cabecera('DATOS DEL CLIENTE');
		$this->SetLineWidth(.3);
		$this->SetFont('Arial','B',10);		
		$this->Cell(100,6,"Razn Social: ".$cliente,1,0,'L');
		$this->Cell(90,6,"CUIT: ".$cuit,1,0,'L');
		$this->Ln();
		$this->Cell(100,6,"Nombre Fantasa:",1,0,'L');
		$this->Cell(90,6,"Cod. Postal: ".$cpostal,1,0,'L');
		$this->Ln();
		$this->Cell(100,6,"Direccin: ".$domicilio,1,0,'L');
		$this->Cell(90,6,"Localidad: ".$localidad,1,0,'L');
		$this->Ln();
		$this->Cell(100,6,"Telfono: ".$telefono,1,0,'L');
		$this->Cell(90,6,"Provincia: ".$provincia,1,0,'L');
		$this->Ln();
		$this->Cell(100,6,"E-mail 1: ".$emai1l,1,0,'L');
		$this->Cell(90,6,"Celular: ".$celular,1,0,'L');
		$this->Ln();		
		$this->Cell(100,6,"E-mail 2: ".$emai12,1,0,'L');
		$this->SetTextColor(0,153,204);
		$this->Cell(90,6,"Vendedor: ".$vendedor,1,0,'L');
		$this->Ln();
	}
	
	function ChapterDetallePedido($datos,$colspan,$fields,$cod_castillo)
	{
		$objNota = new NotaPedido();
		
		$this->SetTextColor(0,0,0);
		$this->SetFont('Arial','',8);
		
		for ($x=0; $x < $colspan; $x++)
		{
			$this->Cell($fields["width_pdf"][$x],5,$fields["concepto_pdf"][$x],1,0,'C');
		}
		
		$this->Ln();
		
		$this->SetFont('Arial','',7);
			
		$this->SetWidths($fields["width_pdf"]);
		
		$this->SetAligns($fields["align_pdf"]);	
		
		while($row=mysql_fetch_array($datos))
		{
			for ($x=0; $x < $colspan; $x++)
			{	
				if (($fields["update"][$x] == "codigo") && ($cod_castillo == 1) && $row["codigo_castillo"] )
				
						$campos[$x] = $row[$fields["update"][$x]]."      (".$row["codigo_castillo"].")";	
				 else 
				 
					$campos[$x] = str_replace('','',$row[$fields["update"][$x]]);	
				
			}
			
			$this->Row($campos);
										 
		}
		
	}
	
	/*
	function ChapterDetallePedido($datos,$colspan,$fields)
	{
		$objNota = new NotaPedido();
		
		$this->SetTextColor(0,0,0);
		$this->SetFont('Arial','',8);
		
		for ($x=0; $x < $colspan; $x++)
		{
			$this->Cell($fields["width_pdf"][$x],5,$fields["concepto_pdf"][$x],1,0,'C');
		}
		
		$this->Ln();
		
		$this->SetFont('Arial','',7);
			
		$this->SetWidths($fields["width_pdf"]);
		
		$this->SetAligns($fields["align_pdf"]);	
		
		while($row=mysql_fetch_array($datos))
		{
			for ($x=0; $x < $colspan; $x++)
			{	
				if (($fields["update"][$x] == "codigo") && ($cod_castillo == 1) && $row["codigo_castillo"])
				
						$campos[$x] = $row[$fields["update"][$x]]."      (".$row["codigo_castillo"].")";	
				 else 
				 
					$campos[$x] = $row[$fields["update"][$x]];	
				
			}
			
			$this->Row($campos);
										 
		}
		
	}
	*/
	
	
	
	function ChapterSubtotal($campo,$descuento,$importe)
	{
		$objNota = new NotaPedido();
		$this->SetLineWidth(.3);
		$this->SetFont('Arial','B',8);
		$this->Cell(140,6,$campo,0,0,'R');
		$this->Cell(20,6,$descuento,0,0,'C');
		$this->Cell(30,6,$objNota->FormatMoney($importe,"pesos ar"),1,0,'R');
		$this->Ln();
	}
	
	function ChapterSubtotalSealy($subtotal)
	{
		$this->SetLineWidth(.3);
		$this->SetFont('Arial','B',9);
		$this->Cell(160,6,"SUBTOTAL",0,0,'R');
		$this->Cell(30,6,FormatoMoneda($subtotal,pesos),1,0,'R');
		$this->Ln();
		$Iva = ($subtotal * 21) / 100;
		$Total = $subtotal + $Iva;
		$this->ChapterIvaTotal(21,$Iva,$Total);
	}
	
	
	function ChapterTotal($campo,$importe)
	{
		$objNota = new NotaPedido();
		$this->SetLineWidth(.3);
		$this->SetFillColor(0);
		$this->SetFont('Arial','B',9);
		$this->Cell(140,6,$campo,0,0,'R');
		$this->Cell(20,6,"",0,0,'C');
		$this->SetTextColor(255);
		$this->Cell(30,6,$objNota->FormatMoney($importe,"pesos ar"),1,0,'R',1);
		$this->Ln(8);
	}
	
		
	function ChapterCondicionVenta($condicion_venta)
	{
		
		$objNota = new NotaPedido();
		$row = $objNota->recortar(';',$condicion_venta);

		$this->CabeceraSLinea('CONDICIONES DE VENTA');
		$this->SetLineWidth(.3);
		$this->SetDrawColor(192);
		$this->SetWidths(array(40,150));		
		$this->SetAligns(array("R","L"));
		$this->SetFont('Arial','',8);
		for ($x=0; $x < count($row); $x++) { 
			$row_venta = $objNota->recortar('#',$row[$x]);
			$this->Row(array($row_venta[0],$row_venta[1]));
		}
		$this->Ln(8);
	}
	
	function ChapterM3($campo,$m3)
	{
		$objNota = new NotaPedido();
		$this->SetLineWidth(.3);
		$this->SetFont('Arial','B',10);
		$this->Cell(140,6,$campo,0,0,'R');
		$this->Cell(20,6,"",0,0,'C');
		$this->Cell(30,6,$m3,1,0,'R');
		$this->Ln();
	}
	
	
	function ChapterBanco($cuentas_banco)
	{
		$objNota = new NotaPedido();
		$row = $objNota->recortar(';',$cuentas_banco);

		$this->CabeceraSLinea('CUENTAS BANCARIAS');
		$this->SetLineWidth(.3);
		$this->SetDrawColor(192);
		$this->SetFont('Arial','BI',8);
		$this->Cell(20,6,"MONEDA",'LRB',0,'C');
		$this->Cell(40,6,"BANCO",'LRB',0,'C');
		$this->Cell(70,6,"CBU",'LRB',0,'C');
		$this->Cell(30,6,"SUCURSAL",'LRB',0,'C');
		$this->Cell(30,6,"CTA. CTE.",'LRB',0,'C');
		$this->Ln();
		for ($x=0; $x < count($row); $x++) { 
			$row_banco = $objNota->recortar('#',$row[$x]);
			$this->SetFont('Arial','',8);
			$this->Cell(20,5,$row_banco[0],1,0,'C');
			$this->Cell(40,5,$row_banco[1],1,0,'L');
			$this->Cell(70,5,$row_banco[2],1,0,'C');
			$this->Cell(30,5,$row_banco[3],1,0,'L');			
			$this->Cell(30,5,$row_banco[4],1,0,'L');
			$this->Ln();
		}
		
	}
	
	
	
	var $widths;
	var $aligns;
	
	function SetWidths($w)
	{
		//Set the array of column widths
		$this->widths=$w;
	}
	
	function SetAligns($a)
	{
		//Set the array of column alignments
		$this->aligns=$a;
	}
	
	function Row($data)
	{
		//Calculate the height of the row
		$nb=0;
		for($i=0;$i<count($data);$i++)
			$nb=max($nb,$this->NbLines($this->widths[$i],$data[$i]));
		$h=5*$nb;
		//Issue a page break first if needed
		$this->CheckPageBreak($h);
		//Draw the cells of the row
		for($i=0;$i<count($data);$i++)
		{
			$w=$this->widths[$i];
			$a=isset($this->aligns[$i]) ? $this->aligns[$i] : 'L';
			//Save the current position
			$x=$this->GetX();
			$y=$this->GetY();
			//Draw the border
			$this->Rect($x,$y,$w,$h);
			//Print the text
			$this->MultiCell($w,5,$data[$i],0,$a);
			//Put the position to the right of the cell
			$this->SetXY($x+$w,$y);
		}
		//Go to the next line
		$this->Ln($h);
	}
	
	function CheckPageBreak($h)
	{
		//If the height h would cause an overflow, add a new page immediately
		if($this->GetY()+$h>$this->PageBreakTrigger)
			$this->AddPage($this->CurOrientation);
	}
	
	function NbLines($w,$txt)
	{
		//Computes the number of lines a MultiCell of width w will take
		$cw=&$this->CurrentFont['cw'];
		if($w==0)
			$w=$this->w-$this->rMargin-$this->x;
		$wmax=($w-2*$this->cMargin)*1000/$this->FontSize;
		$s=str_replace("\r",'',$txt);
		$nb=strlen($s);
		if($nb>0 and $s[$nb-1]=="\n")
			$nb--;
		$sep=-1;
		$i=0;
		$j=0;
		$l=0;
		$nl=1;
		while($i<$nb)
		{
			$c=$s[$i];
			if($c=="\n")
			{
				$i++;
				$sep=-1;
				$j=$i;
				$l=0;
				$nl++;
				continue;
			}
			if($c==' ')
				$sep=$i;
			$l+=$cw[$c];
			if($l>$wmax)
			{
				if($sep==-1)
				{
					if($i==$j)
						$i++;
				}
				else
					$i=$sep+1;
				$sep=-1;
				$j=$i;
				$l=0;
				$nl++;
			}
			else
				$i++;
		}
		return $nl;
	}
	
	function DescuentoMercaderiaSave($fields,$desc_concepto_merc,$desc_mercaderia,
									$desc_mercaderia_detalle,$desc_concepto_1,
									$desc_mercaderia_price1,$desc_concepto_2,
									$desc_mercaderia_price2,$desc_concepto_3,
									$desc_mercaderia_price3,$desc_concepto_4,
									$desc_mercaderia_price4,$desc_concepto_5,
									$desc_mercaderia_price5,$desc_concepto_6,
									$desc_mercaderia_price6,$desc_concepto_7,
									$desc_mercaderia_price7,$desc_concepto_8,
									$desc_mercaderia_price8,$desc_mercaderia_iva,
									$desc_mercaderia_imp_int,$desc_mercaderia_retencion,
									$desc_mercaderia_total,$desc_mercaderia_m3,$colspan){
										
		$Subtotal = $desc_mercaderia;
	
		$this->CabeceraSLinea($desc_concepto_merc);
		$objNota = new NotaPedido();
		
		$this->SetDrawColor(192);
		$this->SetFillColor(192);
		$this->SetTextColor(0);
		$this->SetLineWidth(0.3);
		$this->SetFont('Arial','',8);
		
		for ($x=0; $x < $colspan; $x++)
		{
			$this->Cell($fields["width_pdf"][$x],5,$fields["concepto_pdf"][$x],1,0,'C');
		}
		
		$this->Ln();
		
		$this->SetFont('Arial','',7);
			
		$this->SetWidths($fields["width_pdf"]);
		
		$this->SetAligns($fields["align_pdf"]);
		
		$filas = $objNota->recortar("~",$desc_mercaderia_detalle);
		foreach ($filas as $val){
			$campos = $objNota->recortar("#",$val);	
			
			$this->Row($campos);
		}
		
		
		
		$this->ChapterSubtotal("SUBTOTAL","",$desc_mercaderia);
		
		//DESCUENTOS
		$descuento = $objNota->recortar("#",$desc_concepto_1);		
		if ($descuento[0]) {			
			$mercaderia = $descuento[2];
			$this->ChapterSubtotal($descuento[0],$descuento[1]." %",$desc_mercaderia_price1);
			$Subtotal -= $desc_mercaderia_price1;
			$this->ChapterSubtotal("SUBTOTAL","",$Subtotal);
			
		}
		
		$descuento = $objNota->recortar("#",$desc_concepto_2);
		if ($descuento[0]) {
			
			$mercaderia = $descuento[2];
			$this->ChapterSubtotal($descuento[0],$descuento[1]." %",$desc_mercaderia_price2);
			$Subtotal -= $desc_mercaderia_price2;
			$this->ChapterSubtotal("SUBTOTAL","",$Subtotal);
		}
		
		
		$descuento = $objNota->recortar("#",$desc_concepto_3);
		if ($descuento[0]) {
			
			$mercaderia = $descuento[2];
			$this->ChapterSubtotal($descuento[0],$descuento[1]." %",$desc_mercaderia_price3);
			$Subtotal -= $desc_mercaderia_price3;
			$this->ChapterSubtotal("SUBTOTAL","",$Subtotal);
		}
		
		
		$descuento = $objNota->recortar("#",$desc_concepto_4);
		if ($descuento[0]) {
			
			$mercaderia = $descuento[2];
			$this->ChapterSubtotal($descuento[0],$descuento[1]." %",$desc_mercaderia_price4);
			$Subtotal -= $desc_mercaderia_price4;
			$this->ChapterSubtotal("SUBTOTAL","",$Subtotal);
		}
		
		$descuento = $objNota->recortar("#",$desc_concepto_5);
		if ($descuento[0]) {
			
			$mercaderia = $descuento[2];
			$this->ChapterSubtotal($descuento[0],$descuento[1]." %",$desc_mercaderia_price5);
			$Subtotal -= $desc_mercaderia_price5;
			$this->ChapterSubtotal("SUBTOTAL","",$Subtotal);
		}
		
		$descuento = $objNota->recortar("#",$desc_concepto_6);
		if ($descuento[0]) {
			
			$mercaderia = $descuento[2];
			$this->ChapterSubtotal($descuento[0],$descuento[1]." %",$desc_mercaderia_price6);
			$Subtotal -= $desc_mercaderia_price6;
			$this->ChapterSubtotal("SUBTOTAL","",$Subtotal);
			
		}	
		
		$descuento = $objNota->recortar("#",$desc_concepto_7);
		if ($descuento[0]) {
			
			$mercaderia = $descuento[2];
			$this->ChapterSubtotal($descuento[0],$descuento[1]." %",$desc_mercaderia_price7);
			$Subtotal -= $desc_mercaderia_price7;
			$this->ChapterSubtotal("SUBTOTAL","",$Subtotal);
			
		}	
		
		$descuento = $objNota->recortar("#",$desc_concepto_8);
		if ($descuento[0]) {
			
			$mercaderia = $descuento[2];
			$this->ChapterSubtotal($descuento[0],$descuento[1]." %",$desc_mercaderia_price8);
			$Subtotal -= $desc_mercaderia_price8;
			$this->ChapterSubtotal("SUBTOTAL","",$Subtotal);
			
		}		
		
		//IVA
		$Iva = $objNota->recortar("#",$desc_mercaderia_iva);
		$this->ChapterSubtotal($Iva[0],$Iva[1],$Iva[2]);
		
		//Retencion 
		$Ret = $objNota->recortar("#",$desc_mercaderia_retencion);
		if (!empty($desc_mercaderia_retencion)) {
			$this->ChapterSubtotal($Ret[0],$Ret[1],$Ret[2]);
		}
		
		//Impuestos Internos
		$ImpInt = $objNota->recortar("#",$desc_mercaderia_imp_int);
		if (!empty($desc_mercaderia_imp_int)) {
			$this->ChapterSubtotal($ImpInt[0],$ImpInt[1],$ImpInt[2]);
		}
		
		//Metros Cubicos Mercaderia  Descuento
		if ($desc_mercaderia_m3 > 0 ){
			$this->ChapterM3("TOTAL M3",$desc_mercaderia_m3);
		}
		
		$Total = $objNota->recortar("#",$desc_mercaderia_total);
		$this->ChapterSubtotal($Total[0],"",$Total[2]);
		$this->Ln(5);
	}
	
	
	function DescuentoMercaderia ($sub,$concepto,$desc_mercaderia,$datos,$colspan,$fields,$idrep,$idsub,$tipo_iva,$desc_concepto_1,$desc_concepto_2,$desc_concepto_3,$desc_concepto_4,$desc_concepto_5,$desc_concepto_6,$desc_concepto_7,$desc_concepto_8,$tipo_imp_int,$tipo_retencion)
	{
		$MontoBonificado = $desc_mercaderia;
		$tot_porcentaje = 0;
		$Subtotal = 0;
		$Diferencia = $MontoBonificado;
		$calculo = ($desc_mercaderia / $sub) * 100;
		$tot_porcentaje = round($calculo);
				
		$this->CabeceraSLinea($concepto);
		$objNota = new NotaPedido();
		
		$this->SetDrawColor(192);
		$this->SetFillColor(192);
		$this->SetTextColor(0);
		$this->SetLineWidth(0.3);
		$this->SetFont('Arial','',8);
		
				
		for ($x=0; $x < $colspan; $x++)
		{
			$this->Cell($fields["width_pdf"][$x],5,$fields["concepto_pdf"][$x],1,0,'C');
		}
		
		$this->Ln();
		
		$this->SetFont('Arial','',7);
			
		$this->SetWidths($fields["width_pdf"]);
		
		$this->SetAligns($fields["align_pdf"]);	
		
		while($row=mysql_fetch_array($datos))
		{
				
			$merc_cantidad = ceil($row["cantidad"] * ($tot_porcentaje / 100));
			$merc_subtotal = $row["costo"] * $merc_cantidad;
			$CheckSubtotal = $Subtotal + $merc_subtotal;
			if (($CheckSubtotal < $MontoBonificado) && ($row["costo"] < $Diferencia))
			{
				for ($x=0; $x < $colspan; $x++)
				{		
					if ($fields["update"][$x] == "cantidad")
					{
						$campos[$x] = ceil($row[$fields["update"][$x]] * ($tot_porcentaje / 100));
						$cantidad = $campos[$x];
					
					} else if ($fields["update"][$x] == "costo") {
						
						$campos[$x] = $row[$fields["update"][$x]];
						$costo =  $campos[$x];
						
					} else if ($fields["update"][$x] == "subtotal") {
						
						$campos[$x] = $costo * $cantidad;
						$Diferencia = $Diferencia - $campos[$x];
						$Subtotal += $campos[$x];
											
					} else {
				
						$campos[$x] = $row[$fields["update"][$x]];	
					}
						
				}
			
				$this->Row($campos);
			} else {
				/*
				$calculo = ($Diferencia / $MontoBonificado) * 100;
				$tot_porcentaje = round($calculo);*/
				
				$calculo = ($desc_mercaderia / $sub) * 100;
				$tot_porcentaje = round($calculo - 5);
				$merc_cantidad = ceil($row["cantidad"] * ($tot_porcentaje / 100));
				$merc_subtotal = $row["costo"] * $merc_cantidad;
				$CheckSubtotal = $Subtotal + $merc_subtotal;
				if (($CheckSubtotal < $MontoBonificado) && ($row["costo"] < $Diferencia))
				{
					for ($x=0; $x < $colspan; $x++)
					{		
						if ($fields["update"][$x] == "cantidad")
						{
							$campos[$x] = ceil($row[$fields["update"][$x]] * ($tot_porcentaje / 100));
							$cantidad = $campos[$x];
						
						} else if ($fields["update"][$x] == "costo") {
							
							$campos[$x] = $row[$fields["update"][$x]];
							$costo =  $campos[$x];
							
						} else if ($fields["update"][$x] == "subtotal") {
							
							$campos[$x] = $costo * $cantidad;
							$Diferencia = $Diferencia - $campos[$x];
							$Subtotal += $campos[$x];
												
						} else {
					
							$campos[$x] = $row[$fields["update"][$x]];	
						}
							
					}
			
					$this->Row($campos);
				
				}
			}
										 
		}
		
		
		//Saldo de diferencia del Monto Bonificiado	
		$Diferencia = $MontoBonificado - $Subtotal;
		
		//$consulta_mercaderia = $objNota->search_productos_mercaderia($idrep,$idsub,$Diferencia);
		$articulo = array("2019261","2019264","2019073");
			for ($a=0; $a < count($articulo); $a++)
			{
				$row = $objNota->search_productos_codigo($idrep,$articulo[$a]);
				if (($Subtotal < $MontoBonificado) && ($row["importe"] < $Diferencia) && ($row["importe"] > 0))
				{
					for ($x=0; $x < $colspan; $x++)
					{		
						if ($fields["update"][$x] == "cantidad")
						{
							$campos[$x] = ceil( 0.6 * ($Diferencia / 100));
							$cantidad = $campos[$x];
							
						} else if ($fields["update"][$x] == "costo") {
							
							$campos[$x] = number_format($row["importe"] / 1.21,2);
							$Diferencia = $Diferencia - $campos[$x];
							$costo =  $campos[$x];
							
						} else if ($fields["update"][$x] == "subtotal") {
							
							$campos[$x] = $costo * $cantidad;
							$Subtotal += $campos[$x];
												
						} else {
					
							$campos[$x] = $row[$fields["update"][$x]];	
						}
							
					}
				
					$this->Row($campos);
				}
											 
			}	
			
			$Diferencia = $MontoBonificado - $Subtotal;
			$articulo_2 = array("2019261","2019264","2019073","2019261","2019264","2019073","2019261","2019264","2019073","2019261","2019264","2019073","2019261","2019264","2019073","2019261","2019264","2019073","2019261","2019264","2019073","2019261","2019264","2019073","2019261","2019264","2019073","2019261","2019264","2019073","2019261","2019264","2019073","2019261","2019264","2019073","2019261","2019264","2019073","2019261","2019264","2019073","2019261","2019264","2019073","2019261","2019264","2019073","2019261","2019264","2019073");
			for ($a=0; $a < count($articulo_2); $a++)
			{
				$row = $objNota->search_productos_codigo($idrep,$articulo_2[$a]);
				if (($Subtotal < $MontoBonificado) && ($row["importe"] < $Diferencia) && ($row["importe"] > 0))
				{
					for ($x=0; $x < $colspan; $x++)
					{		
						if ($fields["update"][$x] == "cantidad")
						{
							$campos[$x] = 1;
							$cantidad = $campos[$x];
							
						} else if ($fields["update"][$x] == "costo") {
							
							$campos[$x] = number_format($row["importe"] / 1.21,2);
							$Diferencia = $Diferencia - $campos[$x];
							$costo =  $campos[$x];
							
						} else if ($fields["update"][$x] == "subtotal") {
							
							$campos[$x] = $costo * $cantidad;
							$Subtotal += $campos[$x];
												
						} else {
					
							$campos[$x] = $row[$fields["update"][$x]];	
						}
							
					}
				
					$this->Row($campos);
				}
											 
			}	
			
		$this->ChapterSubtotal("SUBTOTAL","",$Subtotal);
		
		//DESCUENTOS
		$descuento = $objNota->recortar("#",$desc_concepto_1);		
		if ($descuento[0]) {			
			$mercaderia = $descuento[2];
			$importe_descuento = $Subtotal * ($descuento[1] / 100);
			$this->ChapterSubtotal($descuento[0],$descuento[1]." %",$importe_descuento);
			$Subtotal -= $importe_descuento;
			$this->ChapterSubtotal("SUBTOTAL","",$Subtotal);
			
		}
		
		$descuento = $objNota->recortar("#",$desc_concepto_2);
		if ($descuento[0]) {
			
			$mercaderia = $descuento[2];
			$importe_descuento = $Subtotal * ($descuento[1] / 100);
			$this->ChapterSubtotal($descuento[0],$descuento[1]." %",$importe_descuento);
			$Subtotal -= $importe_descuento;
			$this->ChapterSubtotal("SUBTOTAL","",$Subtotal);
		}
		
		
		$descuento = $objNota->recortar("#",$desc_concepto_3);
		if ($descuento[0]) {
			
			$mercaderia = $descuento[2];
			$importe_descuento = $Subtotal * ($descuento[1] / 100);
			$this->ChapterSubtotal($descuento[0],$descuento[1]." %",$importe_descuento);
			$Subtotal -= $importe_descuento;
			$this->ChapterSubtotal("SUBTOTAL","",$Subtotal);
		}
		
		
		$descuento = $objNota->recortar("#",$desc_concepto_4);
		if ($descuento[0]) {
			
			$mercaderia = $descuento[2];
			$importe_descuento = $Subtotal * ($descuento[1] / 100);
			$this->ChapterSubtotal($descuento[0],$descuento[1]." %",$importe_descuento);
			$Subtotal -= $importe_descuento;
			$this->ChapterSubtotal("SUBTOTAL","",$Subtotal);
		}
		
		$descuento = $objNota->recortar("#",$desc_concepto_5);
		if ($descuento[0]) {
			
			$mercaderia = $descuento[2];
			$importe_descuento = $Subtotal * ($descuento[1] / 100);
			$this->ChapterSubtotal($descuento[0],$descuento[1]." %",$importe_descuento);
			$Subtotal -= $importe_descuento;
			$this->ChapterSubtotal("SUBTOTAL","",$Subtotal);
		}
		
		$descuento = $objNota->recortar("#",$desc_concepto_6);
		if ($descuento[0]) {
			
			$mercaderia = $descuento[2];
			$importe_descuento = $Subtotal * ($descuento[1] / 100);
			$this->ChapterSubtotal($descuento[0],$descuento[1]." %",$importe_descuento);
			$Subtotal -= $importe_descuento;
			$this->ChapterSubtotal("SUBTOTAL","",$Subtotal);
			
		}	
		
		$descuento = $objNota->recortar("#",$desc_concepto_7);
		if ($descuento[0]) {
			
			$mercaderia = $descuento[2];
			$importe_descuento = $Subtotal * ($descuento[1] / 100);
			$this->ChapterSubtotal($descuento[0],$descuento[1]." %",$importe_descuento);
			$Subtotal -= $importe_descuento;
			$this->ChapterSubtotal("SUBTOTAL","",$Subtotal);
			
		}	
		
		$descuento = $objNota->recortar("#",$desc_concepto_8);
		if ($descuento[0]) {
			
			$mercaderia = $descuento[2];
			$importe_descuento = $Subtotal * ($descuento[1] / 100);
			$this->ChapterSubtotal($descuento[0],$descuento[1]." %",$importe_descuento);
			$Subtotal -= $importe_descuento;
			$this->ChapterSubtotal("SUBTOTAL","",$Subtotal);
			
		}		
		
		//IVA
		$Iva = $Subtotal * ($tipo_iva / 100);
		$this->ChapterSubtotal("Iva",$tipo_iva,$Iva);
		
		//Retencion 
		$retencion = 0; $imp_interno = 0;
		if ($tipo_retencion > 0) {
			$retencion = ($Subtotal * $tipo_retencion) / 100;
			$this->ChapterSubtotal("RETENCION DE IMPUESTOS",$tipo_retencion,$retencion);
		}
		
		//Impuestos Internos
		if ($tipo_imp_int > 0) {
			$imp_interno = ($Subtotal * $tipo_imp_int) / 100;
			$this->ChapterSubtotal("IMPUESTOS INTERNOS",$tipo_imp_int,$imp_interno);
		}
		
		
		$Total = $Subtotal + $retencion + $imp_interno +  $Iva;
		
		$this->ChapterSubtotal("Total","",$Total);
		$this->Ln(5);
		
	}
	
	function MercaderiaTransporte ($transporte_mercaderia, $transporte_subtotal, $transporte_m3, $transporte_iva, $transporte_imp_int, $transporte_ret, $transporte_total, $colspan, $fields)
	{
				
		$this->CabeceraSLinea('MERCADERIA POR PAGO FLETE $ '. $transporte_subtotal );
		$objNota = new NotaPedido();
		
		$this->SetDrawColor(192);
		$this->SetFillColor(192);
		$this->SetTextColor(0);
		$this->SetLineWidth(0.3);
		$this->SetFont('Arial','',8);
		
				
		for ($x=0; $x < $colspan; $x++)
		{
			$this->Cell($fields["width_pdf"][$x],5,$fields["concepto_pdf"][$x],1,0,'C');
		}
		
		$this->Ln();
		
		$this->SetFont('Arial','',7);
			
		$this->SetWidths($fields["width_pdf"]);
		
		$this->SetAligns($fields["align_pdf"]);
		
		$filas = $objNota->recortar("~",$transporte_mercaderia);
		foreach ($filas as $val){
			$campos = $objNota->recortar("#",$val);
			$this->Row(array($campos[0],$campos[1],$campos[2],$campos[3],$campos[4],$campos[5]));
		}
		
		
		
		$this->ChapterSubtotal("SUBTOTAL","",$transporte_subtotal);
		
		//Metros Cubicos Mercaderia  Descuento
		if ($transporte_m3 > 0 ){
			$this->ChapterM3("TOTAL M3",$transporte_m3);
		}		
		
		//IVA
		$Iva = $objNota->recortar("#",$transporte_iva);
		$this->ChapterSubtotal($Iva[0],$Iva[1],$Iva[2]);
		
		//Impuestos Internos
		$ImpInt = $objNota->recortar("#",$transporte_imp_int);
		if (!empty($transporte_imp_int)) {
			$this->ChapterSubtotal($ImpInt[0],$ImpInt[1],$ImpInt[2]);
		}
		
		//Retencion 
		$Ret = $objNota->recortar("#",$transporte_ret);
		if (!empty($transporte_ret)) {
			$this->ChapterSubtotal($Ret[0],$Ret[1],$Ret[2]);
		}
		
		
		$Total = $objNota->recortar("#",$transporte_total);
		$this->ChapterSubtotal($Total[0],"",$Total[2]);
		
		
		$this->Ln(5);
		
	}
	
	function DescuentoMercaderia_bak ($sub,$concepto,$desc_mercaderia,$datos,$colspan,$fields,$idrep,$idsub,$tipo_iva,$desc_concepto_1,$desc_concepto_2,$desc_concepto_3,$desc_concepto_4,$desc_concepto_5,$desc_concepto_6,$tipo_imp_int,$tipo_retencion)
	{
		$MontoBonificado = $desc_mercaderia;
		$tot_porcentaje = 0;
		$Subtotal = 0;
		$Diferencia = $MontoBonificado;
		$calculo = ($desc_mercaderia / $sub) * 100;
		$tot_porcentaje = round($calculo);
				
		$this->CabeceraSLinea($concepto);
		$objNota = new NotaPedido();
		
		$this->SetDrawColor(192);
		$this->SetFillColor(192);
		$this->SetTextColor(0);
		$this->SetLineWidth(0.3);
		$this->SetFont('Arial','',8);
		
				
		for ($x=0; $x < $colspan; $x++)
		{
			$this->Cell($fields["width_pdf"][$x],5,$fields["concepto_pdf"][$x],1,0,'C');
		}
		
		$this->Ln();
		
		$this->SetFont('Arial','',7);
			
		$this->SetWidths($fields["width_pdf"]);
		
		$this->SetAligns($fields["align_pdf"]);	
		
		while($row=mysql_fetch_array($datos))
		{
			if (($Subtotal < $MontoBonificado) && ($row["costo"] < $Diferencia))
			{
				for ($x=0; $x < $colspan; $x++)
				{		
					if ($fields["update"][$x] == "cantidad")
					{
						$campos[$x] = ceil($row[$fields["update"][$x]] * ($tot_porcentaje / 100));
						$cantidad = $campos[$x];
					
					} else if ($fields["update"][$x] == "costo") {
						
						$campos[$x] = $row[$fields["update"][$x]];
						$costo =  $campos[$x];
						
					} else if ($fields["update"][$x] == "subtotal") {
						
						$campos[$x] = $costo * $cantidad;
						$Diferencia = $Diferencia - $campos[$x];
						$Subtotal += $campos[$x];
											
					} else {
				
						$campos[$x] = $row[$fields["update"][$x]];	
					}
						
				}
			
				$this->Row($campos);
			}
										 
		}
		
		//Saldo de diferencia del Monto Bonificiado	
		$Diferencia = $MontoBonificado - $Subtotal;
		
		$consulta_mercaderia = $objNota->search_productos_mercaderia($idrep,$idsub,$Diferencia);
		
		while($row=mysql_fetch_array($consulta_mercaderia))
		{
			if (($Subtotal < $MontoBonificado) && ($row["importe"] < $Diferencia))
			{
				for ($x=0; $x < $colspan; $x++)
				{		
					if ($fields["update"][$x] == "cantidad")
					{
						$campos[$x] = 1;
						$cantidad = $campos[$x];
						
					} else if ($fields["update"][$x] == "costo") {
						
						$campos[$x] = $row["importe"];
						$Diferencia = $Diferencia - $campos[$x];
						$costo =  $campos[$x];
						
					} else if ($fields["update"][$x] == "subtotal") {
						
						$campos[$x] = $costo * $cantidad;
						$Subtotal += $campos[$x];
											
					} else {
				
						$campos[$x] = $row[$fields["update"][$x]];	
					}
						
				}
			
				$this->Row($campos);
			}
										 
		}	
		
		$this->ChapterSubtotal("SUBTOTAL","",$Subtotal);
		
		//DESCUENTOS
		$descuento = $objNota->recortar("#",$desc_concepto_1);		
		if ($descuento[0]) {			
			$mercaderia = $descuento[2];
			$importe_descuento = $Subtotal * ($descuento[1] / 100);
			$this->ChapterSubtotal($descuento[0],$descuento[1]." %",$importe_descuento);
			$Subtotal -= $importe_descuento;
			$this->ChapterSubtotal("SUBTOTAL","",$Subtotal);
			
		}
		
		$descuento = $objNota->recortar("#",$desc_concepto_2);
		if ($descuento[0]) {
			
			$mercaderia = $descuento[2];
			$importe_descuento = $Subtotal * ($descuento[1] / 100);
			$this->ChapterSubtotal($descuento[0],$descuento[1]." %",$importe_descuento);
			$subtotal -= $importe_descuento;
			$this->ChapterSubtotal("SUBTOTAL","",$subtotal);
		}
		
		
		$descuento = $objNota->recortar("#",$desc_concepto_3);
		if ($descuento[0]) {
			
			$mercaderia = $descuento[2];
			$importe_descuento = $Subtotal * ($descuento[1] / 100);
			$this->ChapterSubtotal($descuento[0],$descuento[1]." %",$importe_descuento);
			$Subtotal -= $importe_descuento;
			$this->ChapterSubtotal("SUBTOTAL","",$Subtotal);
		}
		
		
		$descuento = $objNota->recortar("#",$desc_concepto_4);
		if ($descuento[0]) {
			
			$mercaderia = $descuento[2];
			$importe_descuento = $Subtotal * ($descuento[1] / 100);
			$this->ChapterSubtotal($descuento[0],$descuento[1]." %",$importe_descuento);
			$Subtotal -= $importe_descuento;
			$this->ChapterSubtotal("SUBTOTAL","",$Subtotal);
		}
		
		$descuento = $objNota->recortar("#",$desc_concepto_5);
		if ($descuento[0]) {
			
			$mercaderia = $descuento[2];
			$importe_descuento = $Subtotal * ($descuento[1] / 100);
			$this->ChapterSubtotal($descuento[0],$descuento[1]." %",$importe_descuento);
			$Subtotal -= $importe_descuento;
			$this->ChapterSubtotal("SUBTOTAL","",$Subtotal);
		}
		
		$descuento = $objNota->recortar("#",$desc_concepto_6);
		if ($descuento[0]) {
			
			$mercaderia = $descuento[2];
			$importe_descuento = $Subtotal * ($descuento[1] / 100);
			$this->ChapterSubtotal($descuento[0],$descuento[1]." %",$importe_descuento);
			$Subtotal -= $importe_descuento;
			$this->ChapterSubtotal("SUBTOTAL","",$Subtotal);
			
		}	
		
		$Iva = $Subtotal * ($tipo_iva / 100);
		
		$this->ChapterSubtotal("Iva",$tipo_iva,$Iva);	
		
		//Retencion 
		$retencion = 0; $imp_interno = 0;
		if ($tipo_retencion > 0) {
			$retencion = ($Subtotal * $tipo_retencion) / 100;
			$this->ChapterSubtotal("RETENCION DE IMPUESTOS",$tipo_retencion,$retencion);
		}
		
		//Impuestos Internos
		if ($tipo_imp_int > 0) {
			$imp_interno = ($Subtotal * $tipo_imp_int) / 100;
			$this->ChapterSubtotal("IMPUESTOS INTERNOS",$tipo_imp_int,$imp_interno);
		}
		
		
		$Total = $Subtotal + $retencion + $imp_interno +  $Iva;		
		$this->ChapterSubtotal("Total","",$Total);
		$this->Ln(5);
		
	}
	
	
	function PrintPedido($id)
	{
		//Aadir captulo
		$this->AddPage();
		$objNota = new NotaPedido();
	
		$pedido = $objNota->mostrar_pedido($id);
		$row = mysql_fetch_array($pedido);
		$idrep = $row["idrep"];
		$Sub = $row["idrepsub"];
		$cod_castillo = $row["cod_castillo"];
		
		//Datos Cliente
		$cliente = $row["cliente"];
		$cuit  = $row["cuit"];
		$domicilio = $row["domicilio"];
		$localidad  = $row["localidad"];
		$provincia = $row["provincia"];
		$cpostal = $row["cpostal"];
		$email  = $row["email"];
		$telefono = $row["telefono"];
		
		$subtotal = $row["subtotal"];
		$subtotal_mercaderia = $row["subtotal"];
		
		/* Inicio Datos de Descuento por Mercaderia */
		$desc_concepto_merc = $row["desc_concepto_merc"];
		$desc_mercaderia = $row["desc_mercaderia"];
		$desc_mercaderia_detalle = $row["desc_mercaderia_detalle"];
		$desc_mercaderia_price1 = $row["desc_mercaderia_price1"];
		$desc_mercaderia_price2 = $row["desc_mercaderia_price2"];
		$desc_mercaderia_price3 = $row["desc_mercaderia_price3"];
		$desc_mercaderia_price4 = $row["desc_mercaderia_price4"];
		$desc_mercaderia_price5 = $row["desc_mercaderia_price5"];
		$desc_mercaderia_price6 = $row["desc_mercaderia_price6"];
		$desc_mercaderia_price7 = $row["desc_mercaderia_price7"];
		$desc_mercaderia_price8 = $row["desc_mercaderia_price8"];
		$desc_mercaderia_m3 = $row["desc_mercaderia_m3"];
		$desc_mercaderia_iva = $row["desc_mercaderia_iva"];
		$desc_mercaderia_imp_int = $row["desc_mercaderia_imp_int"];
		$desc_mercaderia_retencion = $row["desc_mercaderia_retencion"];
		$desc_mercaderia_total = $row["desc_mercaderia_total"];
		/* Fin Datos de Descuento por Mercaderia */
		
		/* Inicio Datos de Descuento por Mercaderia */
		$transporte = $row["transporte"];
		$transporte_mercaderia = $row["transporte_mercaderia"];
		$transporte_subtotal = $row["transporte_subtotal"];
		$transporte_m3 = $row["transporte_m3"];
		$transporte_iva = $row["transporte_iva"];
		$transporte_imp_int = $row["transporte_imp_int"];
		$transporte_ret = $row["transporte_ret"];
		$transporte_total = $row["transporte_total"];		
		
		/* Fin Datos de Descuento por Mercaderia */
		
		
		
		$tipo_iva = $row["tipo_iva"];
		$iva = $row["iva"];
		
		$tipo_imp_int = $row["tipo_imp_int"];
		$imp_interno = $row["imp_interno"];
		
		$tipo_percepcion = $row["tipo_percepcion"];
		$percepcion = $row["percepcion"];
		
		$tipo_retencion = $row["tipo_retencion"];
		$retencion = $row["retencion"];
		
		$total = $row["total"];	
		
		$desc_concepto_1 = $row["desc_concepto_1"];
		$desc_concepto_2 = $row["desc_concepto_2"];
		$desc_concepto_3 = $row["desc_concepto_3"];
		$desc_concepto_4 = $row["desc_concepto_4"];
		$desc_concepto_5 = $row["desc_concepto_5"];
		$desc_concepto_6 = $row["desc_concepto_6"];
		$desc_concepto_7 = $row["desc_concepto_7"];
		$desc_concepto_8 = $row["desc_concepto_8"];
		
		$desc_importe_1 = $row["desc_importe_1"];
		$desc_importe_2 = $row["desc_importe_2"];
		$desc_importe_3 = $row["desc_importe_3"];
		$desc_importe_4 = $row["desc_importe_4"];
		$desc_importe_5 = $row["desc_importe_5"];
		$desc_importe_6 = $row["desc_importe_6"];
		$desc_importe_7 = $row["desc_importe_7"];
		$desc_importe_8 = $row["desc_importe_8"];
		
		$condicion_venta = $row["condicion_venta"];
		$cuentas_banco = $row["cuentas_bancarias"];
		
		$mtrs_cubicos = $row["m3"];
		
		//Inicializar Variables	
		$fields = $objNota->SelectFields($objNota->selectCaseForm($idrep));
		$colspan = count ($fields["concepto_pdf"]);
		$filas = $objNota->contar_pedido_detalle($id);
		$datos = $objNota->mostrar_pedido_detalle($id);
		$datos_mercaderia = $objNota->mostrar_pedido_detalle($id);
		$vendedor = "Ramiro Lavilla";
		
		$this->ChapterClient($cliente,$cuit,$domicilio,$localidad,$provincia,$cpostal,$email1, $email2,$telefono,$celular,$vendedor);
		
		$this->ChapterDetallePedido($datos,$colspan,$fields,$cod_castillo);
		
		$this->ChapterSubtotal("SUBTOTAL","",$subtotal);
		$a = 0;
		$b_m = false;
		//DESCUENTOS
		$descuento = $objNota->recortar("#",$desc_concepto_1);		
		if ($descuento[0]) {			
			$mercaderia = $descuento[2];
			$this->ChapterSubtotal($descuento[0],$descuento[1]." %",$desc_importe_1);
			$subtotal -= $desc_importe_1;
			$this->ChapterSubtotal("SUBTOTAL","",$subtotal);
			
		}
		
		$descuento = $objNota->recortar("#",$desc_concepto_2);
		if ($descuento[0]) {
			
			$mercaderia = $descuento[2];
			$this->ChapterSubtotal($descuento[0],$descuento[1]." %",$desc_importe_2);
			$subtotal -= $desc_importe_2;
			$this->ChapterSubtotal("SUBTOTAL","",$subtotal);
		}
		
		
		$descuento = $objNota->recortar("#",$desc_concepto_3);
		if ($descuento[0]) {
			
			$mercaderia = $descuento[2];
			$this->ChapterSubtotal($descuento[0],$descuento[1]." %",$desc_importe_3);
			$subtotal -= $desc_importe_3;
			$this->ChapterSubtotal("SUBTOTAL","",$subtotal);
		}
		
		
		$descuento = $objNota->recortar("#",$desc_concepto_4);
		if ($descuento[0]) {
			
			$mercaderia = $descuento[2];
			$this->ChapterSubtotal($descuento[0],$descuento[1]." %",$desc_importe_4);
			$subtotal -= $desc_importe_4;
			$this->ChapterSubtotal("SUBTOTAL","",$subtotal);
		}
		
		$descuento = $objNota->recortar("#",$desc_concepto_5);
		if ($descuento[0]) {
			
			$mercaderia = $descuento[2];
			$this->ChapterSubtotal($descuento[0],$descuento[1]." %",$desc_importe_5);
			$subtotal -= $desc_importe_5;
			$this->ChapterSubtotal("SUBTOTAL","",$subtotal);
		}
		
		$descuento = $objNota->recortar("#",$desc_concepto_6);
		if ($descuento[0]) {
			
			$mercaderia = $descuento[2];
			$this->ChapterSubtotal($descuento[0],$descuento[1]." %",$desc_importe_6);
			$subtotal -= $desc_importe_6;
			$this->ChapterSubtotal("SUBTOTAL","",$subtotal);
			
		}
		
		$descuento = $objNota->recortar("#",$desc_concepto_7);
		if ($descuento[0]) {
			
			$mercaderia = $descuento[2];
			$this->ChapterSubtotal($descuento[0],$descuento[1]." %",$desc_importe_7);
			$subtotal -= $desc_importe_7;
			$this->ChapterSubtotal("SUBTOTAL","",$subtotal);
			
		}
		
		$descuento = $objNota->recortar("#",$desc_concepto_8);
		if ($descuento[0]) {
			
			$mercaderia = $descuento[2];
			$this->ChapterSubtotal($descuento[0],$descuento[1]." %",$desc_importe_8);
			$subtotal -= $desc_importe_8;
			$this->ChapterSubtotal("SUBTOTAL","",$subtotal);
			
		}
		
		//Iva		
		if ($tipo_iva > 0) {
			$this->ChapterSubtotal("IVA",$tipo_iva,$iva);
		}
		
		//Percepcion 
		if ($tipo_percepcion > 0) {
			$this->ChapterSubtotal("PERCEPCION IIBB",$tipo_percepcion,$percepcion);
		}
		
		//Retencion 
		if ($tipo_retencion > 0) {
			$this->ChapterSubtotal("PERCEPCION IVA",$tipo_retencion,$retencion);
		}
		
		//Impuestos Internos
		if ($tipo_imp_int > 0) {
			$this->ChapterSubtotal("IMPUESTOS INTERNOS",$tipo_imp_int,$imp_interno);
		}
				
		//Metros Cbicos
		if ($mtrs_cubicos > 0){
			$this->ChapterM3("TOTAL M3",$mtrs_cubicos);
		}
		
		//Total
		$this->ChapterTotal("TOTAL",$total);
		
		//Descuento Mercaderia 
		if (($desc_mercaderia > 0) && empty($desc_mercaderia_detalle))
		{
			$this->DescuentoMercaderia($subtotal_mercaderia,$desc_concepto_merc,$desc_mercaderia,$datos_mercaderia,$colspan,$fields,$idrep,$Sub,$tipo_iva,$desc_concepto_1,$desc_concepto_2,$desc_concepto_3,$desc_concepto_4,$desc_concepto_5,$desc_concepto_6,$desc_concepto_7,$desc_concepto_8,$tipo_imp_int,$tipo_retencion);
		} elseif (($desc_mercaderia > 0) && !empty($desc_mercaderia_detalle)) {
			$this->DescuentoMercaderiaSave($fields,$desc_concepto_merc,$desc_mercaderia,
											$desc_mercaderia_detalle,$desc_concepto_1,
											$desc_mercaderia_price1,$desc_concepto_2,
											$desc_mercaderia_price2,$desc_concepto_3,
											$desc_mercaderia_price3,$desc_concepto_4,
											$desc_mercaderia_price4,$desc_concepto_5,
											$desc_mercaderia_price5,$desc_concepto_6,
											$desc_mercaderia_price6,$desc_concepto_7,
											$desc_mercaderia_price7,$desc_concepto_8,
											$desc_mercaderia_price8,$desc_mercaderia_iva,
											$desc_mercaderia_imp_int,$desc_mercaderia_retencion,
											$desc_mercaderia_total,$desc_mercaderia_m3,$colspan);
		}
		
		//Condicion de Venta
		$this->ChapterCondicionVenta($condicion_venta);
		
		//Cuentas Bancarias		
		$this->ChapterBanco($cuentas_banco);
		
		//Mercaderia Transporte 
		if (($transporte_subtotal > 0) && !empty($transporte_mercaderia))
		{
			$this->AddPage();
			$this->MercaderiaTransporte($transporte_mercaderia, $transporte_subtotal, $transporte_m3, $transporte_iva, $transporte_imp_int, $transporte_ret, $transporte_total, $colspan, $fields);
		} 
		
	}
}


	
	$objNota = new NotaPedido();

	$val = $objNota->print_pedido_pdf($_GET["code"]);
	if ($val){
		$id = $val["IdPedido"];
		$idrep = $val["idrep"];
		$idrepsub = $val["idrepsub"];
		$nro_pedido = $val["nro_pedido"];		
		$pdf=new PDF();
		$MADERA = $objNota->check_color($id);		
		
		$title='NOTA DE PEDIDO N '.$objNota->add_ceros($nro_pedido,6);
		$tit_cliente = "DATOS DEL CLIENTE";
		$IDREP = $idrep;
		$IDREPSUB = $idrepsub;
		$dia = $objNota->CambiarFSqlToNormal($val["fecha"]);
		$pdf->SetTitle($title);
		$pdf->PrintPedido($id);
		
		if(!empty($_GET["name_file"]))
			$pdf->Output($_GET["name_file"],'D');
		else
			$pdf->Output();
	}else {
		header("location:http://www.sovicsrl.com.ar/");
	}
} else { 
	header("location:http://www.sovicsrl.com.ar/");
}
?>
