
function formatItem(row) {
	return row[2] + " (" + row[0] + ")";
	
}

$(document).ready(function (){
	
	$("#empresa").focus();
	
	$("#empresa").autocomplete("autocompletar.php?act=ventas_clientes")
	  .result(function (evt, data, formatted) {			
		$("#domicilio").val(data[1]);
		$("#provincia").val(data[2]);
		$("#tipo_iva").val(data[3]);
		$("#telefono").val(data[4]);
		$("#cuit").val(data[5]);
		$("#idcliente").val(data[6]);
		$("#fecha").focus();
	});
	
	
	/* Salto de campo con Enter */
	$("input").not( $(":button") ).keypress(function (evt) {
		if (evt.keyCode == 13) {
			iname = $(this).val();
			if (iname !== 'Submit'){
				var fields = $(this).parents('form:eq(0),body').find('button, input, textarea, select');
				var index = fields.index( this );
				if ( index > -1 && ( index + 1 ) < fields.length ) {
					fields.eq( index + 1 ).focus();
				}
				return false;
			}
		}
	});
	
	$("select").not( $(":button") ).keypress(function (evt) {
		if (evt.keyCode == 13) {
			iname = $(this).val();
			if (iname !== 'Submit'){
				var fields = $(this).parents('form:eq(0),body').find('button, input, textarea, select');
				var index = fields.index( this );
				if ( index > -1 && ( index + 1 ) < fields.length ) {
					fields.eq( index + 1 ).focus();
				}
				return false;
			}
		}
	});
	
	
	/* Calculo de Saldo */
	$("input[name^=importe]").bind("keyup", calcsubtotal);
	$("input[name^=cantidad]").bind("keyup", calcsubtotal);
	
	calcsubtotal();  recalc();
	
	var isCtrl = false;$(document).keyup(function (e) {
	if(e.which == 121) isCtrl=false;
	}).keydown(function (e) {
		
		if(e.which == 121) {
			GuardarForm ();
		return false;
	 }
	});
		
		
});

function addRows(obj){
	$("#cant_campos").val(parseInt($("#cant_campos").val()) + 1);
	var oId = $("#cant_campos").val();
	var cantidad = $("#cantidad").val();
	var descripcion = $("#descripcion").val();
	var importe = $("#importe").val();
	var subtotal = $("#subtotal").val();
	
	var error = "";
	
	if (!cantidad.length)
		error += "Por favor ingresar cantidad\n";
		
	
	if (!descripcion.length)
		error += "Por favor ingresar descripcion\n";
		
	if (!importe.length)
		error += "Por favor ingresar importe\n";
		
	if (!error)
	{
		var strHtml1 = '<td>'+ cantidad +'<input type="hidden" id="hdnCantidad_' + oId + '" name="hdnCantidad_' + oId + '" value="' + cantidad + '"/></td>';
		var strHtml2 = '<td>'+ descripcion +'<input type="hidden" id="hdnDescripcion_' + oId + '" name="hdnDescripcion_' + oId + '" value="' + descripcion + '"/></td>';
		var strHtml3 = '<td>'+ importe +'<input type="hidden" id="hdnImporte_' + oId + '" name="hdnImporte_' + oId + '" value="' + importe + '"/></td>';
		var strHtml4 = '<td>'+ subtotal +'<input type="hidden" id="hdnSubtotal_' + oId + '" name="hdnSubtotal_' + oId + '" value="' + subtotal + '"/></td>';
		var strHtml5 = '<td><img src="images/delete.png" width="16" height="16" alt="Eliminar" onclick="delRow(' + oId + ');"/>';
		
		var strHtmlTr = "<tr id='rowDetalle_" + oId + "'></tr>";
		var strHtmlFinal = strHtml1 + strHtml2 + strHtml3 +  strHtml4 +  strHtml5;
		
		$("#tbDetalle").append(strHtmlTr);
		
		$("#rowDetalle_" + oId).html(strHtmlFinal);
		
		$("#cantidad").val('');
		$("#descripcion").val('');
		$("#importe").val('');
		$("#subtotal").val('');		
		$("#cantidad").focus();	
		recalc();
		
	} else 
		alert(error);
	return false;
		
}


function delRow(oId){
	var r = confirm('Desea eliminar esta descripcion?');
	if (r){	

		$("#rowDetalle_" + oId).remove();	
		recalc();
	}
	return false;
}


function Clear(){
	window.location.reload();
	return false;
}

function GuardarForm(){
	var total = parseFloat($("#total").val());
	var idcliente = parseInt($("#idcliente").val());
	var nrofactura = parseInt($("#nrofactura").val());
	
	
	
	if ((total > 0) && (idcliente != 0) && (nrofactura)){
		
		var str = $("#frmIvaVenta").serialize();
		var r= confirm( 'Esta seguro de Guardar?');

			if (r){							  
				  $.ajax({
					async:	true, 
					url:	"save.php",
					type:	"POST",
					data: str,
					contentType: 'application/x-www-form-urlencoded',
					dataType: "json",
					success: function(data){
						
						if (data.error){
							
							alert(data.error);
							
						} else {
							var s= confirm( 'Se registro con exito. Desea Imprimir?');
							if (s){							
								window.open ("gastos/factura_imprimir.php?id=" + data.ok );
								window.location.reload();
							} else {
								window.location.reload();
							}
							

						}
						
					}
				});
				
				
			}
		
		
	} else if (idcliente == 0) {
		alert("Seleccionar una representacion.");
		$("#empresa").focus();	
	
	} else if (total == 0) {
		alert("Ingresar descripcion de concepto");
		$("#descripcion").focus();	
	
	}  else if (!nrofactura) {
		alert("Ingresar nro. factura.");
		$("#descripcion").focus();	
	
	} 
		
	
}


function add() {
	var tb = addRows(document.getElementById('cant_campos'));
	eval(tb.value);	
		
	return false;
}


			


/*----------------------------------------
		Calcular Total
 ----------------------------------------- */

function recalc(){
	var valor = $("input[name^='hdnSubtotal_']").sum();
	$("#total").attr("value",valor.toFixed(2));
}

function calcsubtotal (){ 
	// run the calc() method on each of the "total" fields 
	 
	
	$("[id^=subtotal]").calc( 
		// the equation to use for the calculation 
		"cantidad * importe", 
		// we now define the values for the variables defined in the equation above 
		{ 
			// instead of using a static value, we use a jQuery object which grabs all the quantities 
			cantidad: $("input[name^=cantidad]"), 
			importe: $("input[name^=importe]")
			
		}, 
		// this function is execute after the calculation is completed, which allows us to 
		// add formatting to our value 
		function (s){ 
			// return the number as a dollar amount 
			return s.toFixed(2); 
		}
	); 
	
}
