	function recalc(){ 
		// run the calc() method on each of the "total" fields 
		
		$("[@id^=subtotal_]").calc( 
			// the equation to use for the calculation 
			"qty * price", 
			// we now define the values for the variables defined in the equation above 
			{ 
				// instead of using a static value, we use a jQuery object which grabs all the quantities 
				qty: $("input[@name^=cantidad_]"), 
				// now we define the jQuery object which reads in the "price" from the table cell 
				price: $("[@id^=costo_]") 
			}, 
			// this function is execute after the calculation is completed, which allows us to 
			// add formatting to our value 
			function (s){ 
				// return the number as a dollar amount 
				return s.toFixed(2); 
			}, 
			// once all calculations are completed, we execute the code below 
			function ($this){ 
				// now we get the sum() of all the values we just calculated 
				var sum = $this.sum(); 

				// now that we have the grand total, we must update the screen 
				$("#Subtotal").val( 
					// round the results to 2 digits 
					sum.toFixed(2) 
				); 
			} 
		); 
		
		$("[@id^=Iva]").calc( 
			// the equation to use for the calculation 
			"qty * (tipo_iva / 100)", 
			// we now define the values for the variables defined in the equation above 
			{ 
				// instead of using a static value, we use a jQuery object which grabs all the quantities 
				qty: $("input[@name^=Subtotal]"), 
				// now we define the jQuery object which reads in the "price" from the table cell 
				tipo_iva: $("[@id^=tipo_iva]") 
			}, 
			// this function is execute after the calculation is completed, which allows us to 
			// add formatting to our value 
			function (s){ 
				// return the number as a dollar amount 
				return s.toFixed(2); 
			}
		); 
		
		$("[@id^=Total]").calc( 
			// the equation to use for the calculation 
			"subtotal + iva", 
			// we now define the values for the variables defined in the equation above 
			{ 
				// instead of using a static value, we use a jQuery object which grabs all the quantities 
				subtotal: $("input[@name^=Subtotal]"), 
				// now we define the jQuery object which reads in the "price" from the table cell 
				iva: $("[@id^=Iva]") 
			}, 
			// this function is execute after the calculation is completed, which allows us to 
			// add formatting to our value 
			function (s){ 
				// return the number as a dollar amount 
				return s.toFixed(2); 
			}
		);
		
		
	}
	
	function marckup(){ 
		// run the calc() method on each of the "total" fields 
		
		$("[@id^=costo_]").calc( 
			// the equation to use for the calculation 
			"(qty / (1+(marckup / 100))) / (1+((impint+iva) / 100))", 
			// we now define the values for the variables defined in the equation above 
			{ 
				// instead of using a static value, we use a jQuery object which grabs all the quantities 
				qty: $("input[@name^=plista_]"), 
				// now we define the jQuery object which reads in the "price" from the table cell 
				marckup: $("[@id^=mup_]"), 
				impint: $("[@id^=imp_int_]"),
				iva: $("[@id^=iva_]") 
			},
			// this function is execute after the calculation is completed, which allows us to 
			// add formatting to our value 
			
			function (s){ 
				// return the number as a dollar amount 
				return s.toFixed(2); 
			}
		); 
		
	}
	
			
	function calc_iva(){ 
		// run the calc() method on each of the "total" fields 
		
		$("[@id^=Iva]").calc( 
			// the equation to use for the calculation 
			"qty * (iva / 100)", 
			// we now define the values for the variables defined in the equation above 
			{ 
				// instead of using a static value, we use a jQuery object which grabs all the quantities 
				qty: $("input[@name^=Subtotal]"), 
				// now we define the jQuery object which reads in the "price" from the table cell 
				iva: $("[@id^=tipo_iva]") 
			},
			// this function is execute after the calculation is completed, which allows us to 
			// add formatting to our value 
			
			function (s){ 
				// return the number as a dollar amount 
				return s.toFixed(2); 
			}
		);  
	}
	
	
	
	function calc_total(){ 
		// run the calc() method on each of the "total" fields 
		
		$("[@id^=Total]").calc( 
			// the equation to use for the calculation 
			"subtotal + iva", 
			// we now define the values for the variables defined in the equation above 
			{ 
				// instead of using a static value, we use a jQuery object which grabs all the quantities 
				iva: $("input[@name^=Iva]"), 
				
				subtotal: $("[@id^=Subtotal]") 
				
				
			},
			// this function is execute after the calculation is completed, which allows us to 
			// add formatting to our value 
			
			function (s){ 
				// return the number as a dollar amount 
				return s.toFixed(2); 
			}
		);  
	}
	
	
	function CalcularUpdate(idrep)
	{
		if (idrep == 26) { marckup(); }
		$("[@id^=subtotal_]").calc( 
			// the equation to use for the calculation 
			"qty * price", 
			// we now define the values for the variables defined in the equation above 
			{ 
				// instead of using a static value, we use a jQuery object which grabs all the quantities 
				qty: $("input[@name^=cantidad_]"), 
				// now we define the jQuery object which reads in the "price" from the table cell 
				price: $("[@id^=costo_]") 
			}, 
			// this function is execute after the calculation is completed, which allows us to 
			// add formatting to our value 
			function (s){ 
				// return the number as a dollar amount 
				return s.toFixed(2); 
			}, 
			// once all calculations are completed, we execute the code below 
			function ($this){ 
				// now we get the sum() of all the values we just calculated 
				var sum = $this.sum(); 

				// now that we have the grand total, we must update the screen 
				$("#Subtotal").val( 
					// round the results to 2 digits 
					sum.toFixed(2) 
				); 
			} 
		); 
		
		calc_iva();
		calc_total();	
		
	}