<?php
require("./NewsSql.inc.php");
$db = new NewsSQL($DBName);

require('../fpdf/fpdf.php');

////////////////////////////////////////////////////
//Convierte fecha de mysql a normal
////////////////////////////////////////////////////
function cambiaf_a_normal($fecha){
    ereg( "([0-9]{2,4})-([0-9]{1,2})-([0-9]{1,2})", $fecha, $mifecha);
    $lafecha=$mifecha[3]."/".$mifecha[2]."/".$mifecha[1];
    return $lafecha;
} 

////////////////////////////////////////////////////
//Convierte fecha de normal a mysql
////////////////////////////////////////////////////

function cambiaf_a_mysql($fecha){
    ereg( "([0-9]{1,2})/([0-9]{1,2})/([0-9]{2,4})", $fecha, $mifecha);
    $lafecha=$mifecha[3]."-".$mifecha[2]."-".$mifecha[1];
    return $lafecha;
} 

class PDF extends FPDF
{
	var $Subtotal;
	var $Iva;
	var $Total;
	
	var $widths;
	var $aligns;
	
	function Footer()
	{
		// Go to 1.5 cm from bottom
		$this->SetY(-10);
		
		//Subtotal
		 $this->SetFont('Arial','B',10);
		 $this->SetXY(155,-30);
		 $this->Cell(15,5,"",0,0); 
		 $this->Cell(30,5,$this->Subtotal,0,1,"R");
				  
		 $this->SetXY(155,-24);
		 $this->SetFont('Arial','B',8);
		 $this->Cell(15,5,"21%",0,0,"C"); 
		 $this->SetFont('Arial','B',10);
		 $this->Cell(30,5,$this->Iva,0,1,"R");
		  
		 $this->SetXY(155,-18);
		 $this->Cell(15,5,"",0,0); 
		 $this->Cell(30,5,$this->Total,0,0,"R");
	}
	
	function SetWidths($w)
	{
		//Set the array of column widths
		$this->widths=$w;
	}
	
	function SetAligns($a)
	{
		//Set the array of column alignments
		$this->aligns=$a;
	}
	
	function Row($data)
	{
		//Calculate the height of the row
		$nb=0;
		for($i=0;$i<count($data);$i++)
			$nb=max($nb,$this->NbLines($this->widths[$i],$data[$i]));
		$h=5*$nb;
		//Issue a page break first if needed
		$this->CheckPageBreak($h);
		//Draw the cells of the row
		for($i=0;$i<count($data);$i++)
		{
			$w=$this->widths[$i];
			$a=isset($this->aligns[$i]) ? $this->aligns[$i] : 'L';
			//Save the current position
			$x=$this->GetX();
			$y=$this->GetY();
			//Draw the border
			$this->Rect($x,$y,$w,$h);
			//Print the text
			$this->MultiCell($w,5,$data[$i],0,$a);
			//Put the position to the right of the cell
			$this->SetXY($x+$w,$y);
		}
		//Go to the next line
		$this->Ln($h);
	}
	
	function CheckPageBreak($h)
	{
		//If the height h would cause an overflow, add a new page immediately
		if($this->GetY()+$h>$this->PageBreakTrigger)
			$this->AddPage($this->CurOrientation);
	}
	
	function NbLines($w,$txt)
	{
		//Computes the number of lines a MultiCell of width w will take
		$cw=&$this->CurrentFont['cw'];
		if($w==0)
			$w=$this->w-$this->rMargin-$this->x;
		$wmax=($w-2*$this->cMargin)*1000/$this->FontSize;
		$s=str_replace("\r",'',$txt);
		$nb=strlen($s);
		if($nb>0 and $s[$nb-1]=="\n")
			$nb--;
		$sep=-1;
		$i=0;
		$j=0;
		$l=0;
		$nl=1;
		while($i<$nb)
		{
			$c=$s[$i];
			if($c=="\n")
			{
				$i++;
				$sep=-1;
				$j=$i;
				$l=0;
				$nl++;
				continue;
			}
			if($c==' ')
				$sep=$i;
			$l+=$cw[$c];
			if($l>$wmax)
			{
				if($sep==-1)
				{
					if($i==$j)
						$i++;
				}
				else
					$i=$sep+1;
				$sep=-1;
				$j=$i;
				$l=0;
				$nl++;
			}
			else
				$i++;
		}
		return $nl;
	}
}


if (is_numeric($_GET["id"])){


	$id = $_GET["id"];
	
	if(!empty($id)){
	$result = $db->getfacturaxid($id);
	}
	
	$pdf=new PDF("P","mm",array(210,297));
	
	$pdf->SetMargins(0,0,0);
	
	
	if (!empty($result)){
		
	  while (list($key,$val)=each($result)) {
		  $pdf->AddPage();
		  $pdf->SetMargins(0,0,0);
		  $idfactura = stripslashes($val["idfactura"]);
		  $fecha = stripslashes($val["fecha"]);
		  $fecha = cambiaf_a_normal($fecha);
		  $empresa = stripslashes($val["empresa"]);
		  $cuit = stripslashes($val["cuit"]);
		  $idcliente = stripslashes($val["idcliente"]);
		  $tipo = stripslashes($val["tipo_iva"]);
		  $tipo_fac = stripslashes($val["tipo_fac"]);
		  $iva21 = stripslashes($val["iva"]);
		  $total = stripslashes($val["importe"]);
		  $comentario = stripslashes($val["comentario"]);
		  $domicilio = $db->getdomfactura($idcliente);
		  $provincia = $db->getprovfactura($idcliente);
		  if ($tipo == 'I'){
		  $iva = "RESPONSABLE INSCRIPTO";
		  } else if ($tipo == 'F'){
		  $iva = "CONSUMIDOR FINAL";
		  }
		  $cuit = stripslashes($val["cuit"]);
		  $importe = stripslashes($val["importe"]);
		  $importe_siva = stripslashes($val["importesiva"]);
		  if ($tipo_fac == 'NCR'){
		  $total = -($total);
		  $importe_siva = -($importe_siva);
		  $iva21 = -($iva21);
		  }
		  $resultdetalle = $db->getfacturadetalle($idfactura); 
		  $pdf->SetFont('Arial','',11);
		  //Fecha
		  $pdf->SetXY(130,33);
		  $pdf->Cell(30,6,$fecha,0,0); 
		  
		  $pdf->SetFont('Arial','',8);
		  
		  $pdf->SetXY(35,70);
		  
		  //Datos del Cliente
		  $pdf->Cell(75,5,$empresa,0,0); 
		  $pdf->Cell(30,5,"",0,0);
		  $pdf->Cell(30,5,"",0,1);
		  
		  $pdf->SetX(35);
		  $pdf->Cell(75,5,$idcliente,0,0); 
		  $pdf->Cell(30,5,"",0,0);
		  $pdf->Cell(30,5,$cuit,0,1); 
		  
		  $pdf->SetX(35);
		  $pdf->Cell(75,5,$domicilio." - ".$provincia,0,0); 
		  $pdf->Cell(30,5,"",0,0);
		  $pdf->Cell(30,5,"EFECTIVO",0,1); 
		  
		  $pdf->SetX(35);
		  $pdf->Cell(75,5,$iva,0,0); 
		  $pdf->Cell(30,5,"",0,0);
		  $pdf->Cell(30,5,"",0,1);  
		  
		  $pdf->Ln(15);
		  
		  $pdf->SetFont('Arial','',9);
		  
		  
		  //Detalle Factura
		  if (!empty($resultdetalle)){
			  $pdf->SetAligns(array("C","L","R","R"));
			  $pdf->SetWidths(array(20,120,25,25));
			  $pdf->SetDrawColor(255);
			  while (list($key,$val)=each($resultdetalle)) {
				$codigo = stripslashes($val["codigo"]);
				$cantidad = stripslashes($val["cantidad"]);
				$descripcion = stripslashes($val["descripcion"]);
				$importe = stripslashes($val["importe"]);
				if ($tipo_fac == 'NCR'){
				$importe = -($importe);
				}
		  
			  $pdf->SetX(10);
			 
			  $pdf->Row(array($cantidad,$descripcion,$importe_siva,$importe_siva));

			  }
		  }
		  
		  //Observacion
		  $pdf->SetXY(40,260);
		  $pdf->Cell(90,6,$comentario,0,1); 
		  
		  $pdf->Subtotal = $importe_siva;
		  $pdf->Iva = $iva21;
		  $pdf->Total = $total;
		  
		  
		  
	  }
	}
	
	
	$pdf->Output();
} else { 
	header("location:http://www.sovicsrl.com.ar/");
}
?>

		
