<?php
require('fpdf.php');
include '../conexion.php';
require '../script/funciones.php';
//include ("../validacion.php");
$RRow = SelectPedProcesadoCode($_GET["code"]);
$id = $RRow["IdPedido"];
if (!empty($id)) {
$idrep =  $RRow["idrep"];
$accion = "procesar_pdf";
include ("../excel/plantilla_funciones.php3");

class PDF extends FPDF
{
	//Columna actual
	var $col=0;
	//Ordenada de comienzo de la columna
	var $y0;
	
	function Header()
	{
		//Cabacera
		global $title;
		global $dia;
		global $IDREP;
		$row = RepresentacionesxID ($IDREP);
		$logo_emp= "logo.jpg";
		$this->SetFont('Arial','B',12);
		$w=0;
		$this->SetX(10);
		$this->SetDrawColor(0,0,0);
		$this->SetFillColor(255,255,255);
		$this->SetTextColor(0,0,0);
		$this->SetLineWidth(0.3);
		$this->Cell($w,18,$title,1,1,'C',1);
		if (!empty($row["img_logo"])){
			$this->Image('../../clientes/img/'.$row["img_logo"],11,12,0,15,'',$row["web"]);
		}
		$this->Image('../../clientes/img/'.$logo_emp,160,12,0,13,'','http://www.sovicsrl.com.ar');
		$this->SetFont('Arial','B',9);
		$this->Cell(100,6,$row["domicilio"].' - '.$row["localidad"],1,0,'L');
		$this->Cell(90,6,'CUIT: 30-71090838-5',1,0,'C');
		$this->Ln();
		$this->Cell(100,6,ProvinciaName($row["provincia"]).' ('.$row["cpostal"].') - CUIT: '.$row["cuit"],1,0,'L');
		$this->Cell(90,6,'E-mail: rlavilla@arnet.com.ar',1,0,'C');
		$this->Ln();
		$this->Cell($w,6,'Fecha: '.$dia,1,1,'R',1);
		$this->Ln();
	
		
		//Guardar ordenada
		$this->y0=$this->GetY();
	}
	
	function Footer()
	{
		//Pie de pgina
		$this->SetY(-15);
		$this->SetFont('Arial','I',8);
		$this->SetTextColor(128);
		$this->Cell(0,10,'Pgina '.$this->PageNo(),0,0,'C');
	}
	
	function Cabecera($text)
	{
		$this->SetFont('Arial','B',12);
		$this->SetDrawColor(0,0,0);
		$this->SetFillColor(192,192,192);
		$this->SetTextColor(0,0,0);
		$this->SetLineWidth(0.5);
		$this->Cell($w,5,$text,1,1,'C',1);
	}
	
	
	function ChapterClient($cliente,$vendedor)
	{
		//Abrir fichero de texto
		$this->Cabecera('DATOS DEL CLIENTE');
		$this->SetLineWidth(.3);
		$this->SetFont('Arial','B',10);
		$result = ClienteAllDatos($cliente);
		$row = mysql_fetch_assoc($result);
		$this->Cell(100,6,"Razn Social: ".$row["nombre"],1,0,'L');
		$this->Cell(90,6,"CUIT: ".$row["cuit"],1,0,'L');
		$this->Ln();
		$this->Cell(100,6,"Nombre Fantasa:",1,0,'L');
		$this->Cell(90,6,"Cod. Postal: ".$row["codpostal"],1,0,'L');
		$this->Ln();
		$this->Cell(100,6,"Direccin: ".$row["direccion"],1,0,'L');
		$this->Cell(90,6,"Localidad: ".$row["localidad"],1,0,'L');
		$this->Ln();
		$this->Cell(100,6,"Telfono: ".$row["telefono"],1,0,'L');
		$this->Cell(90,6,"Provincia: ".ProvinciaName($row["provincia"]),1,0,'L');
		$this->Ln();
		$this->Cell(100,6,"E-mail 1: ".$row["email1"],1,0,'L');
		$this->Cell(90,6,"Celular: ".$row["celular"],1,0,'L');
		$this->Ln();
		$this->Cell(100,6,"E-mail 2: ".$row["email2"],1,0,'L');
		$this->SetTextColor(0,153,204);
		$this->Cell(90,6,"Vendedor: ".$vendedor,1,0,'L');
		$this->Ln();
	}
	
	function ChapterDetallePedidoCodigo($id)
	{
		//Abrir fichero de texto
		$this->Cabecera('DETALLE DEL PEDIDO');
		$this->SetLineWidth(.3);
		$this->SetFont('Arial','BI',9);
		$this->Cell(20,6,"CANTIDAD",1,0,'C');
		$this->Cell(25,6,"CODIGO",1,0,'C');
		$this->Cell(85,6,"DESCRIPCION",1,0,'C');
		$this->Cell(25,6,"PRECIO",1,0,'C');
		$this->Cell(35,6,"TOTAL",1,0,'C');
		$this->Ln();
		$this->SetFont('Arial','',6);
		$consulta =  ListadoProcesadoDetalle($id);
		while ($row=mysql_fetch_assoc($consulta)) {
		$this->Cell(20,6,$row["cantidad"],1,0,'C');
		$this->Cell(25,6,$row["codigo"],1,0,'C');
		$this->Cell(85,6,$row["articulo"],1,0,'L');
		$this->Cell(25,6,FormatoMoneda($row["unitario"],pesos),1,0,'R');
		$this->Cell(35,6,FormatoMoneda($row["total"],pesos),1,0,'R');
		$this->Ln();
		}
		
	}
	
	function ChapterDetallePedidoColorSCod($id)
	{
		//Abrir fichero de texto
		$this->Cabecera('DETALLE DEL PEDIDO');
		$this->SetLineWidth(.3);
		$this->SetFont('Arial','BI',9);
		$this->Cell(20,6,"CANTIDAD",1,0,'C');		
		$this->Cell(85,6,"DESCRIPCION",1,0,'C');
		$this->Cell(25,6,"COLOR",1,0,'C');
		$this->Cell(25,6,"PRECIO",1,0,'C');
		$this->Cell(35,6,"TOTAL",1,0,'C');
		$this->Ln();
		$this->SetFont('Arial','',6);
		$consulta =  ListadoProcesadoDetalle($id);
		while ($row=mysql_fetch_assoc($consulta)) {
		$this->Cell(20,6,$row["cantidad"],1,0,'C');
		$this->Cell(85,6,$row["articulo"],1,0,'C');
		$this->Cell(25,6,$row["color"],1,0,'C');
		$this->Cell(25,6,FormatoMoneda($row["unitario"],pesos),1,0,'R');
		$this->Cell(35,6,FormatoMoneda($row["total"],pesos),1,0,'R');
		$this->Ln();
		}
		
	}
	
	function ChapterDetallePedidoColor($id)
	{
		//Abrir fichero de texto
		$this->Cabecera('DETALLE DEL PEDIDO');
		$this->SetLineWidth(.3);
		$this->SetFont('Arial','BI',9);
		$this->Cell(20,6,"CANTIDAD",1,0,'C');
		$this->Cell(20,6,"CODIGO",1,0,'C');
		$this->Cell(70,6,"DESCRIPCION",1,0,'C');
		$this->Cell(20,6,"COLOR",1,0,'C');
		$this->Cell(25,6,"PRECIO",1,0,'C');
		$this->Cell(35,6,"TOTAL",1,0,'C');
		$this->Ln();
		$this->SetFont('Arial','',6);
		$consulta =  ListadoProcesadoDetalle($id);
		while ($row=mysql_fetch_assoc($consulta)) {
		$this->Cell(20,6,$row["cantidad"],1,0,'C');
		$this->Cell(20,6,$row["codigo"],1,0,'C');
		$this->Cell(70,6,$row["articulo"],1,0,'L');
		$this->Cell(20,6,$row["color"],1,0,'C');
		$this->Cell(25,6,FormatoMoneda($row["unitario"],pesos),1,0,'R');
		$this->Cell(35,6,FormatoMoneda($row["total"],pesos),1,0,'R');
		$this->Ln();
		}
		
	}
	
	function ChapterDetallePedidoLago($id)
	{
		//Abrir fichero de texto
		$this->Cabecera('DETALLE DEL PEDIDO');
		$this->SetLineWidth(.3);
		$this->SetFont('Arial','BI',9);
		$this->Cell(70,6,"DESCRIPCION",1,0,'C');
		$this->Cell(20,6,"CAO",1,0,'C');
		$this->Cell(20,6,"TAPIZADO",1,0,'C');
		$this->Cell(20,6,"TAP. COLOR",1,0,'C');
		$this->Cell(20,6,"CANTIDAD",1,0,'C');
		$this->Cell(20,6,"PRECIO",1,0,'C');
		$this->Cell(20,6,"TOTAL",1,0,'C');
		$this->Ln();
		$this->SetFont('Arial','',6);
		$consulta =  ListadoProcesadoDetalle($id);
		while ($row=mysql_fetch_assoc($consulta)) {
			
		$this->Cell(70,6,$row["articulo"],1,0,'L');
		$this->Cell(20,6,$row["cano"],1,0,'C');
		$this->Cell(20,6,$row["tapizado"],1,0,'C');
		$this->Cell(20,6,$row["color"],1,0,'C');
		$this->Cell(20,6,$row["cantidad"],1,0,'C');			
		$this->Cell(20,6,FormatoMoneda($row["unitario"],pesos),1,0,'R');
		$this->Cell(20,6,FormatoMoneda($row["total"],pesos),1,0,'R');
		$this->Ln();
		}
		
	}
	
	function ChapterDetallePedidoMarckup($id)
	{
		//Abrir fichero de texto
		$this->Cabecera('DETALLE DEL PEDIDO');
		$this->SetLineWidth(.3);
		$this->SetFont('Arial','BI',9);
		$this->Cell(20,6,"CANTIDAD",1,0,'C');
		$this->Cell(60,6,"DESCRIPCION",1,0,'C');
		$this->Cell(25,6,"PRECIO LISTA",1,0,'C');
		$this->Cell(25,6,"MARCK UP",1,0,'C');
		$this->Cell(25,6,"PRECIO UNIT.",1,0,'C');
		$this->Cell(35,6,"TOTAL",1,0,'C');
		$this->Ln();
		$this->SetFont('Arial','',6);
		$consulta =  ListadoProcesadoDetalle($id);
		while ($row=mysql_fetch_assoc($consulta)) {
		$pvp = ProductoImporte($row["codigo"]);
		$this->Cell(20,6,$row["cantidad"],1,0,'C');
		$this->Cell(60,6,$row["codigo"]." - ".$row["articulo"],1,0,'L');
		$this->Cell(25,6,FormatoMoneda($pvp,pesos),1,0,'R');
		$this->Cell(25,6,$row["marckup"],1,0,'C');
		$this->Cell(25,6,FormatoMoneda($row["unitario"],pesos),1,0,'R');
		$this->Cell(35,6,FormatoMoneda($row["total"],pesos),1,0,'R');
		$this->Ln();
		}
		
	}
	
	function ChapterSubtotal($subtotal)
	{
		$this->SetLineWidth(.3);
		$this->SetFont('Arial','B',9);
		$this->Cell(155,6,"SUBTOTAL",1,0,'R');
		$this->Cell(35,6,FormatoMoneda($subtotal,pesos),1,0,'R');
		$this->Ln();
	}
	
	function ChapterDescuento($idrep,$diva,$descuento,$subtotal,$percepcion)
	{
		$this->SetLineWidth(.3);
		$this->SetFont('Arial','B',9);	
		if ($idrep == 1) {	
			$row = DescuentoGrupo($descuento);
			for ($x=0; $x <= strlen($row); $x++ ){
				if (!empty($row[$x])) { 
					$Descuento = DescuentoImporte($row[$x],$subtotal); 
					$subtotal = $subtotal - $Descuento; 
					//Agrega Lineas de Descuento
					$this->Cell(155,6,DescuentoConcepto($row[$x]),1,0,'R');
					$this->Cell(35,6,FormatoMoneda($Descuento,pesos),1,0,'R');
					$this->Ln();
					//Agrega Lineas de Subtotal
					$this->Cell(155,6,"SUBTOTAL",1,0,'R');
					$this->Cell(35,6,FormatoMoneda($subtotal,pesos),1,0,'R');
					$this->Ln();
				}
			}
		} else {
			if (!empty($descuento)) {
				$RDescuento = ListadoDescuentoxID($descuento);
				$RDesc = mysql_fetch_assoc($RDescuento);
				$Descuento = $subtotal * ($RDesc["descuento"]); 
				$subtotal = $subtotal - $Descuento;	
				//Agrega Lineas de Descuento
				$this->Cell(155,6,$RDesc["concepto"],1,0,'R');
				$this->Cell(35,6,FormatoMoneda($Descuento,pesos),1,0,'R');
				$this->Ln();
				//Agrega Lineas de Subtotal
				$this->Cell(155,6,"SUBTOTAL",1,0,'R');
				$this->Cell(35,6,FormatoMoneda($subtotal,pesos),1,0,'R');
				$this->Ln();
			}
		
		}
		//Verifica si tiene percepcion
		if (!empty($percepcion)) { $diva = $diva + $percepcion; }		
		$Iva = ($subtotal * $diva) / 100;
		$Total = $subtotal + $Iva;
		$this->ChapterIvaTotal($diva,$Iva,$Total,$percepcion);
	}
	
	function ChapterDescuentoArray($subtotal,$descuentos,$Total){
		
		$this->SetLineWidth(.3);
		$this->SetFont('Arial','B',9);	
		$fields = explode(";",$descuentos);
		foreach($fields as $field){
			$row = explode("#",$field);			
			//Agrega Lineas de Descuento
			$this->Cell(155,6,$row[0]. " " . $row[1],1,0,'R');
			$this->Cell(35,6,FormatoMoneda($row[2],pesos),1,0,'R');
			$this->Ln();
			$subtotal -=  $row[2];
			
			if (!strstr($row[0],"IVA")):
				//Agrega Lineas de Subtotal
				$this->Cell(155,6,"SUBTOTAL",1,0,'R');
				$this->Cell(35,6,FormatoMoneda($subtotal,pesos),1,0,'R');
				$this->Ln();
			endif;	
		}
		
		$this->Cell(155,6,"TOTAL",1,0,'R');
		$this->Cell(35,6,FormatoMoneda($Total,pesos),1,0,'R');
		$this->Ln();
		
	}
	
	function ChapterIvaTotal($diva,$Iva,$Total,$percepcion)
	{
		$this->SetLineWidth(.3);
		$this->SetFont('Arial','B',9);
		if (!empty($percepcion)) { 
		$this->Cell(155,6,"IVA + PERCEPCION ".$diva."%",1,0,'R');
		$this->Cell(35,6,FormatoMoneda($Iva,pesos),1,0,'R');
		} else {
		$this->Cell(155,6,"IVA ".$diva."%",1,0,'R');
		$this->Cell(35,6,FormatoMoneda($Iva,pesos),1,0,'R');
		}
		$this->Ln();
		$this->Cell(155,6,"TOTAL",1,0,'R');
		$this->Cell(35,6,FormatoMoneda($Total,pesos),1,0,'R');
		$this->Ln();
	}
	
	function ChapterCondVenta($cond_venta,$pago,$f_entrega,$comment)
	{
		//Abrir fichero de texto
		$this->Cabecera('CONDICIONES DE VENTA');
		$this->SetLineWidth(.3);
		$this->SetFont('Arial','BI',9);
		$this->Cell(40,6,"PLAZO DE PAGO:",1,0,'R');
		$this->SetFont('Arial','',9);
		$this->Cell(150,6,$pago,1,0,'L');
		$this->Ln();
		$this->SetFont('Arial','BI',9);
		$this->Cell(40,6,"FECHA DE ENTREGA:",1,0,'R');
		$this->SetFont('Arial','',9);
		$this->Cell(150,6,$f_entrega,1,0,'L');
		$this->Ln();
		if (!empty($cond_venta))
		{
			$result = split(",",$cond_venta);
			for ($x=0; $x < count($result); $x++) {
				$row = split(":",$result[$x]);
				$this->SetFont('Arial','BI',9);
				$this->Cell(40,6,$row[0],1,0,'R');
				$this->SetFont('Arial','',9);
				$this->Cell(150,6,$row[1],1,0,'L');
				$this->Ln();
			}
		}
		if(!empty($comment)){
		$this->SetFont('Arial','BI',9);
		$this->Cell(40,6,"COMENTARIO:",1,0,'R');
		$this->SetFont('Arial','',8);
		$this->Cell(150,6,$comment,1,0,'L');
		$this->Ln();
		}
		
	}
	
	function ChapterFlete($idflete,$flete_cargo)
	{
		//Abrir fichero de texto
		$this->Cabecera('FLETE');
		$this->SetLineWidth(.3);
		//Listado de Cuentas por Representacion
		$row= SelectTransportesxID($idflete);
		$this->Cell(100,6,"Flete a cargo de: ".$flete_cargo,1,0,'L');
		$this->Cell(90,6,"Cod. Postal: ".$row["cpostal"],1,0,'L');
		$this->Ln();
		$this->Cell(100,6,"Transporte: ".$row["empresa"],1,0,'L');
		$this->Cell(90,6,"Provincia: ".$row["provincia"],1,0,'L');
		$this->Ln();
		$this->Cell(100,6,"Direccin: ".$row["direccion"],1,0,'L');
		$this->Cell(90,6,"Localidad: ".$row["localidad"],1,0,'L');
		$this->Ln();
		$this->Cell(100,6,"Telfono: ".$row["telefono"],1,0,'L');
		$this->Cell(90,6,"Contacto: ".$row["contacto"],1,0,'L');
		$this->Ln();
		$this->Cell(190,6,"E-mail: ".$row["email"],1,0,'L');
		$this->Ln();
	}
	
	
	function ChapterBanco($idrep)
	{
		//Abrir fichero de texto
		$this->Cabecera('CUENTAS BANCARIAS');
		$this->SetLineWidth(.3);
		$this->SetFont('Arial','BI',9);
		$this->Cell(20,6,"MONEDA",1,0,'C');
		$this->Cell(40,6,"BANCO",1,0,'C');
		$this->Cell(70,6,"CBU",1,0,'C');
		$this->Cell(30,6,"SUCURSAL",1,0,'C');
		$this->Cell(30,6,"CTA. CTE.",1,0,'C');
		$this->Ln();
		$this->SetFont('Arial','',9);
		//Listado de Cuentas por Representacion
		$result= SelectCuentasBancarias($idrep);
		while ($row=mysql_fetch_assoc($result)) {
		$this->Cell(20,6,$row["moneda"],1,0,'C');
		$this->Cell(40,6,$row["banco"],1,0,'C');
		$this->Cell(70,6,$row["cbu"],1,0,'C');
		$this->Cell(30,6,$row["sucursal"],1,0,'C');
		$this->Cell(30,6,$row["cta_cte"],1,0,'C');
		$this->Ln();
		}
		
	}
	
	function PrintPedido($id,$idrep,$flete_cargo,$idflete,$pago,$f_entrega,$cliente,$vendedor,$subtotal,$descuento,$percepcion,$diva,$comment,$cond_venta,$PConcDescuentos,$PTotal)
	{
		//Aadir captulo
		$this->AddPage();
		$this->ChapterClient($cliente,$vendedor);
		if (($idrep == 26) || ($idrep==31)) { 
		$this->ChapterDetallePedidoMarckup($id);
		} else if (($idrep == 1)|| ($idrep==39)) {
		$this->ChapterDetallePedidoColor($id);
		} else if ($idrep==47) {
		$this->ChapterDetallePedidoLago($id);
		} else if ($idrep==48){
		$this->ChapterDetallePedidoColorSCod($id);
		} else { 
		$this->ChapterDetallePedidoCodigo($id);
		}
		$this->ChapterSubtotal($subtotal);
		if (empty($PConcDescuentos))
			$this->ChapterDescuento($idrep,$diva,$descuento,$subtotal,$percepcion);
		else
			$this->ChapterDescuentoArray($subtotal,$PConcDescuentos,$PTotal);
		$this->ChapterCondVenta($cond_venta,$pago,$f_entrega,$comment);
		$this->ChapterFlete($idflete,$flete_cargo);
		$this->ChapterBanco($idrep);
		
	}
}


$pdf=new PDF();

$title='NOTA DE PEDIDO N '.$PNroPed;
$tit_cliente = "DATOS DEL CLIENTE";
$IDREP = $idrep;
$dia = CambiarFSqlToNormal($RRow["fecha"]);
if ($PIva105 > 0 ) { $diva = 10.5; } else {$diva = 21; } 
$pdf->SetTitle($title);
$pdf->PrintPedido($id,$idrep,$PFleteCargo,$PTransporte,$PFpago, $PFechaEntrega,$PIdcliente,$CVendedor,$PSubtotal,$PDesc,$PPIva,$diva,$PComentario,$PCond_venta,$PConcDescuentos,$PTotal);
$pdf->Output();
} else {
header ('location:../../index.php');
}
?>