<?php

/**
 * Class extention for Header and Footer Definitions
 *
 */
class pdf_usage extends fpdf_table
{
	
	function Header()
	{
		//Cabacera
		global $FECHA;
		global $TRANPORTE;
		global $NGUIA;
		global $REPRESENTACION;
		$logo_emp= "logo.jpg";
		$w=0;
		$this->SetX(10);
		
		$this->SetFont('arial','B',10);
		$this->SetLineWidth(0.3);
		$this->SetDrawColor(51);
		$this->SetFillColor(255);
		$this->SetTextColor(0);	
		$this->Cell(100,10,"",0,0,'C',0);
		$this->Image('img/'.$logo_emp,12,5,0,10,'','http://www.sovicsrl.com.ar');
		$this->SetDrawColor(51);
		$this->SetFillColor(51);
		$this->SetTextColor(0);
		$this->Cell(90,10,$REPRESENTACION,1,1,'C',0);
		$this->SetTextColor(0);
		$this->SetFont('arial','B',8);
		$this->Cell(100,5,"San Juan Nro. 242 Piso 3 - Dpto. I",0,0,'L',0);
		$this->SetFont('arial','B',8);
		$this->Cell(90,5,"",0,1,'L',0);
		$this->SetFont('arial','B',8);
		$this->Cell(100,5,"SAN MIGUEL DE TUCUMAN (T4000DPF) Argentina",0,0,'L',0);
		$this->SetFont('arial','B',10);
		$this->Cell(90,5,"Fecha: ".$FECHA,0,1,'L',0);
		$this->SetFont('arial','B',8);
		$this->Cell(100,5,"rlavilla@sovicsrl.com.ar  - www.sovicsrl.com.ar",0,0,'L',0);
		$this->SetFont('arial','B',10);
		$this->Cell(90,5,"",0,1,'L',0);
		$this->Ln();
			/*
			$this->Cell(195,8,"PLANILLA DE ENVIO DE CORRESPONDENCIA",1,1,'C',0);
			$this->Cell(100,8,"REPRESENTANTE: SOVIC REPRESENTACIONES S.R.L.",1,0,'L',0);
			$this->Cell(95,8,"FECHA: ".$FECHA,1,1,'L',0);
		*/

	}
	
	function Footer()
	{
		//Pie de página
		$this->SetY(-15);
		$this->SetFont('times','I',8);
		$this->SetTextColor(128);
		$this->Cell(0,10,'Página '.$this->PageNo(),0,0,'C');
	}
	
	
	var $widths;
	var $aligns;
	
	function SetWidths($w)
	{
		//Set the array of column widths
		$this->widths=$w;
	}
	
	function SetAligns($a)
	{
		//Set the array of column alignments
		$this->aligns=$a;
	}
	
	function Row($data)
	{
		//Calculate the height of the row
		$nb=0;
		for($i=0;$i<count($data);$i++)
			$nb=max($nb,$this->NbLines($this->widths[$i],$data[$i]));
		$h=5*$nb;
		//Issue a page break first if needed
		$this->CheckPageBreak($h);
		//Draw the cells of the row
		for($i=0;$i<count($data);$i++)
		{
			$w=$this->widths[$i];
			$a=isset($this->aligns[$i]) ? $this->aligns[$i] : 'L';
			//Save the current position
			$x=$this->GetX();
			$y=$this->GetY();
			//Draw the border
			$this->Rect($x,$y,$w,$h);
			//Print the text
			$this->MultiCell($w,5,$data[$i],0,$a);
			//Put the position to the right of the cell
			$this->SetXY($x+$w,$y);
		}
		//Go to the next line
		$this->Ln($h);
	}
	
	function CheckPageBreak($h)
	{
		//If the height h would cause an overflow, add a new page immediately
		if($this->GetY()+$h>$this->PageBreakTrigger)
			$this->AddPage($this->CurOrientation);
	}
	
	function NbLines($w,$txt)
	{
		//Computes the number of lines a MultiCell of width w will take
		$cw=&$this->CurrentFont['cw'];
		if($w==0)
			$w=$this->w-$this->rMargin-$this->x;
		$wmax=($w-2*$this->cMargin)*1000/$this->FontSize;
		$s=str_replace("\r",'',$txt);
		$nb=strlen($s);
		if($nb>0 and $s[$nb-1]=="\n")
			$nb--;
		$sep=-1;
		$i=0;
		$j=0;
		$l=0;
		$nl=1;
		while($i<$nb)
		{
			$c=$s[$i];
			if($c=="\n")
			{
				$i++;
				$sep=-1;
				$j=$i;
				$l=0;
				$nl++;
				continue;
			}
			if($c==' ')
				$sep=$i;
			$l+=$cw[$c];
			if($l>$wmax)
			{
				if($sep==-1)
				{
					if($i==$j)
						$i++;
				}
				else
					$i=$sep+1;
				$sep=-1;
				$j=$i;
				$l=0;
				$nl++;
			}
			else
				$i++;
		}
		return $nl;
	}

} 


?>