<?php
/**
 * Handles the Grid's header
 * The header includes 2 part, the mapping for data to be populated into the datagrid
 * and then the header label for the data grid.
 * 
 * The Header would include the headername in which the data grid would
 * use to  map data in formating data and putting it into the right column
 * 
 * And then the Header Label. The label would be a Descriptive text for the
 * data grid's columns.  By Default, if there is no header lable provided,
 * the system would use the header name instead.
 *  
 * 
 * @version 0.1
 * @author John Paul de Guzman <jpdguzman@gmail.com>
 * @package DataGrid
 * */
class DataGridHeader extends Html{
	
	/**
	 * Data Grid: Header Name
	 * 
	 * @var string
	 * */
	var $headerName;
	
	/**
	 * Data Grid: Display Title
	 * 
	 * @var string
	 * */
	var $displayTitle;
	
	/**
	 * Html Object Attributes
	 * 
	 * @var array
	 * */
	var $__htmlAttributes;
	
	
	
	/** 
	 * Default Constructor for Data Grid Header
	 * This constructor set the display title blank as default
	 * 
	 * @param string headerName
	 * @param string displayTitle
	 * @param array __htmlAttributes
	 * */
	function DataGridHeader($headerName, $displayTitle = '', $__htmlAttributes = null) {
		$this->headerName = $headerName;
		
		if($displayTitle != "") {
			$this->displayTitle = $displayTitle;	
		} else {
			$this->displayTitle = $headerName;
		}
		
		
		// set tag to TD
		$this->_tag = "td";
		$this->setId("dg_header");
		$this->setAttributes($__htmlAttributes);
		
	}
	
	/**
	 * Get Header Name
	 * 
	 * @return headerName
	 * */
	function getHeaderName() {
		return $this->headerName;
	}
	
	
	/**
	 * Get Display Title
	 * 
	 * return displayTitle
	 * */
	function getDisplayTitle() {
		return $this->displayTitle;
	}
	
	
	/**
	 * Output HTML Header
	 * 
	 * @return string
	 * */
	function output() {
		// display title
		$_html = $this->open();
		$_html .= $this->getDisplayTitle().$this->close();
		
		// returns output tag
		return $_html;
	}
}


/**
 * Collection of DataGridHeader
 * This class handles all the header defined in the grid.
 * 
 * @version 0.1
 * @author John Paul de Guzman <jpdguzman@gmail.com>
 * @package DataGrid
 * */
class DataGridHeaderContainer extends Html {
	/**
	 * Collection DataGridHeader objects defined
	 * Associative array, using headerName as key
	 * 
	 * @var array 
	 	 * */
    var $_container;
    
    /**
     * Html attributes
     * 
     * @var array
     * */
    var $__htmlAttributes;
    
    /**
     * Default Constructor
     * Automatically set the collected and defined header during instantiation.
     * For additional custom attributes, htmlAttributes array can be added
     * The Data Grid Container would use a collection of DataGridHeader object
     * 
     * @param array collection
     * @param array __htmlAttributes
     * */
    function DataGridHeaderContainer($collection = null, $__htmlAttributes = null) {
    	
    	// if the collection is not empty
    	if(count($collection) > 0) {
    		
    		// load all the header to the collection
    		foreach($collection as $header) {
    			$this->_container[$header->getHeaderName()] = $header;
    		}
    		
    	}
    	// if the collection is empty 
    	else {
    		// set to a new collection array
    		$this->_container = array();
    	}
    	
    	$this->_tag = "tr";
    	$this->_attributes = $__htmlAttributes;
    	
    }
    
    /**
     * Add a New Header to the container
     * 
     * @param dataGridHeader - DataGridHeader object
     * */
    function addHeader($objDataGridHeader) {
    	// add header to container
    	$this->_container[$objDataGridHeader->getHeaderName()] = $objDataGridHeader;
    }
    
    /**
     * Returns a specific header
     * 
     * @param string headerName
     * @return DataGridHeader Object
     * */
    function getHeader($headerName) {
 		// get the selected header
 		return $this->_container[$headerName];   	
    }
    
    /**
     * Get the header container array
     * 
     * @return Collection of DataGridHeader Object
     * */
    function getAllHeaders() {
    	// return the container
    	return $this->_container;
    }
    
    /**
     * Displays Container header
     * 
     * @return string
     * */
    function output() {
    	// generate an html output
    	$_html = $this->open()."\n";
    	
    	// loop through all header
    	foreach($this->_container as $header) {
    		$_html .= $header->output();
    	}
    	
    	// close tag
    	$_html .= $this->close();
    	
    	// returns html tag
    	return $_html;
    }
}

?>
