<?php 
define('__ROOTSERVER__', dirname(dirname(__FILE__)));
include_once (__ROOTSERVER__."/clases/conexion.class.php");
require_once (__ROOTSERVER__."/includes/database_tables.php");

class Main{
 //constructor	
 	var $con;
	
	
 	function __construct (){
 		$this->con=new DBManager;
 	}
	
	
	
	public function formatMoneda($valor){
		
		return number_format($valor,"2",",",".");
		
	}
	

	
	public function add_ceros($numero,$ceros) {
		$order_diez = explode(".",$numero);
		$dif_diez = $ceros - strlen($order_diez[0]);
		for($m = 0 ; $m < $dif_diez; $m++)
		{
			@$insertar_ceros .= 0;
		}
		return $insertar_ceros .= $numero;
	}
	
	public function CambiarFSqlToNormal($fecha){
		ereg( "([0-9]{2,4})-([0-9]{1,2})-([0-9]{1,2})", $fecha, $mifecha);
		$lafecha=$mifecha[3]."/".$mifecha[2]."/".$mifecha[1];
		return $lafecha;
	} 
	
	public function CambiarFNormalToSql($fecha){
		ereg( "([0-9]{2,2})/([0-9]{1,2})/([0-9]{1,4})", $fecha, $mifecha);
		$lafecha=$mifecha[3]."-".$mifecha[2]."-".$mifecha[1];
		return $lafecha;
	}
	
	public function CambiarFNorGuiToSql($fecha){
		ereg( "([0-9]{2,2})-([0-9]{1,2})-([0-9]{1,4})", $fecha, $mifecha);
		$lafecha=$mifecha[3]."-".$mifecha[2]."-".$mifecha[1];
		return $lafecha;
	}
	
	public function DiasEntreFechas($fecha1, $fecha2)
	{
		ereg( "([0-9]{2,4})-([0-9]{1,2})-([0-9]{1,2})", $fecha1, $mifecha1);
		ereg( "([0-9]{2,4})-([0-9]{1,2})-([0-9]{1,2})", $fecha2, $mifecha2);
		//defino fecha 1
		$ano1 = $mifecha1[1];
		$mes1 = $mifecha1[2]; 
		$dia1 = $mifecha1[3];
		
		//defino fecha 2
		$ano2 = $mifecha2[1];
		$mes2 = $mifecha2[2];
		$dia2 = $mifecha2[3];
		
		//calculo timestam de las dos fechas
		$timestamp1 = mktime(0,0,0,$mes1,$dia1,$ano1);
		$timestamp2 = mktime(0,0,0,$mes2,$dia2,$ano2);
		
		//resto a una fecha la otra
		$segundos_diferencia = $timestamp1 - $timestamp2;
		//echo $segundos_diferencia;
		
		//convierto segundos en días
		$dias_diferencia = $segundos_diferencia / (60 * 60 * 24);
		
		//obtengo el valor absoulto de los días (quito el posible signo negativo)
		$dias_diferencia = abs($dias_diferencia);
		
		//quito los decimales a los días de diferencia
		$dias_diferencia = floor($dias_diferencia);
		
		return  $dias_diferencia;
	}
	
	
	public function SumaFechasSql($fecha,$ndias)
	{
	
		  if (preg_match("/[0-9]{1,4}\/[0-9]{1,2}\/([0-9][0-9]){1,2}/",$fecha))
				  list($año,$mes,$dia)=split("-", $fecha);
				
		  if (preg_match("/[0-9]{1,4}-[0-9]{1,2}-([0-9][0-9]){1,2}/",$fecha))	
				  list($año,$mes,$dia)=split("-",$fecha);
				  
		  $nueva = mktime(0,0,0, $mes,$dia,$año) + $ndias * 24 * 60 * 60;
		  $nuevafecha=date("Y-m-d",$nueva);
	
		  return ($nuevafecha);  
	}

	public function RestaFechasSql($fecha,$ndias)
	{
	  if (preg_match("/[0-9]{1,4}\/[0-9]{1,2}\/([0-9][0-9]){1,2}/",$fecha))
			  list($año,$mes,$dia)=split("-", $fecha);

	  if (preg_match("/[0-9]{1,4}-[0-9]{1,2}-([0-9][0-9]){1,2}/",$fecha))
			  list($año,$mes,$dia)=split("-",$fecha);
			  
	  $nueva = mktime(0,0,0, $mes,$dia,$año) - $ndias * 24 * 60 * 60;
	  $nuevafecha=date("Y-m-d",$nueva);
			
	  return ($nuevafecha);  
	}
	
	public function FormatoMoneda($val){
		return  number_format($val,2,",",".");	
	}


}
?>